/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.core.type.TypeReference;
import com.vaadin.collaborationengine.EntryScope;
import com.vaadin.collaborationengine.HasExpirationTimeout;
import com.vaadin.collaborationengine.ListInsertResult;
import com.vaadin.collaborationengine.ListKey;
import com.vaadin.collaborationengine.ListSubscriber;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.flow.shared.Registration;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface CollaborationList
extends HasExpirationTimeout {
    public <T> List<T> getItems(Class<T> var1);

    public <T> List<T> getItems(TypeReference<T> var1);

    public <T> T getItem(ListKey var1, Class<T> var2);

    public <T> T getItem(ListKey var1, TypeReference<T> var2);

    public Stream<ListKey> getKeys();

    default public ListInsertResult<Void> insertLast(Object item) {
        return this.insertLast(item, EntryScope.TOPIC);
    }

    public ListInsertResult<Void> insertLast(Object var1, EntryScope var2);

    default public CompletableFuture<Boolean> set(ListKey key, Object value) {
        return this.set(key, value, EntryScope.TOPIC);
    }

    public CompletableFuture<Boolean> set(ListKey var1, Object var2, EntryScope var3);

    default public CompletableFuture<Boolean> remove(ListKey key) {
        return this.set(key, null);
    }

    @Deprecated
    default public CompletableFuture<Void> append(Object item) {
        return this.append(item, EntryScope.TOPIC);
    }

    @Deprecated
    default public CompletableFuture<Void> append(Object item, EntryScope scope) {
        return this.insertLast(item, scope).getCompletableFuture();
    }

    public Registration subscribe(ListSubscriber var1);

    public TopicConnection getConnection();

    @Override
    public Optional<Duration> getExpirationTimeout();

    @Override
    public void setExpirationTimeout(Duration var1);
}

