/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.collaborationengine.Backend;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class LocalBackend
implements Backend {
    private final UUID id = UUID.randomUUID();

    @Override
    public Backend.EventLog openEventLog(String topicId) {
        return new LocalEventLog(topicId);
    }

    @Override
    public Backend.EventLog getMembershipEventLog() {
        return new Backend.EventLog(){

            @Override
            public Registration subscribe(UUID newerThan, BiConsumer<UUID, ObjectNode> eventConsumer) {
                assert (newerThan == null);
                ObjectNode event = JsonUtil.createNodeJoin(LocalBackend.this.id);
                eventConsumer.accept(UUID.randomUUID(), event);
                return (Registration & Serializable)() -> {};
            }

            @Override
            public void submitEvent(UUID trackingId, ObjectNode eventPayload) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public UUID getNodeId() {
        return this.id;
    }

    @Override
    public CompletableFuture<ObjectNode> loadLatestSnapshot(String name) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void submitSnapshot(String name, ObjectNode snapshot) {
    }

    private static class LocalEventLog
    implements Backend.EventLog {
        private final String topicId;
        private BiConsumer<UUID, ObjectNode> consumer;

        private LocalEventLog(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public Registration subscribe(UUID newerThan, BiConsumer<UUID, ObjectNode> consumer) {
            if (this.consumer != null) {
                throw new IllegalStateException("Already subscribed to " + this.topicId);
            }
            this.consumer = consumer;
            return (Registration & Serializable)() -> {
                this.consumer = null;
            };
        }

        @Override
        public void submitEvent(UUID trackingId, ObjectNode event) {
            if (this.consumer == null) {
                throw new IllegalStateException("Not subscribed to " + this.topicId);
            }
            this.consumer.accept(trackingId, event);
        }
    }
}

