/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;

public abstract class AbstractCollaborationManager {
    private final CollaborationEngine collaborationEngine;
    private final UserInfo localUser;
    private final String topicId;
    private Registration topicRegistration;
    private ActivationHandler activationHandler;
    private Registration deactivationHandler;
    private boolean active;

    protected AbstractCollaborationManager(UserInfo localUser, String topicId, CollaborationEngine collaborationEngine) {
        this.localUser = Objects.requireNonNull(localUser);
        this.topicId = Objects.requireNonNull(topicId);
        this.collaborationEngine = Objects.requireNonNull(collaborationEngine);
    }

    protected void openTopicConnection(ConnectionContext context, SerializableFunction<TopicConnection, Registration> connectionActivationCallback) {
        if (this.topicRegistration != null) {
            this.topicRegistration.remove();
        }
        this.topicRegistration = this.collaborationEngine.openTopicConnection(context, this.topicId, this.localUser, (SerializableFunction<TopicConnection, Registration>)(SerializableFunction & Serializable)connection -> {
            Registration callbackRegistration;
            this.active = true;
            if (this.activationHandler != null) {
                this.deactivationHandler = this.activationHandler.onActivation();
            }
            return (callbackRegistration = (Registration)connectionActivationCallback.apply(connection)) != null ? Registration.combine((Registration[])new Registration[]{callbackRegistration, this::onTopicRegistrationRemove}) : this::onTopicRegistrationRemove;
        });
    }

    public void setActivationHandler(ActivationHandler handler) {
        if (this.deactivationHandler != null) {
            this.deactivationHandler.remove();
            this.deactivationHandler = null;
        }
        this.activationHandler = handler;
        if (this.active && this.activationHandler != null) {
            this.deactivationHandler = this.activationHandler.onActivation();
        }
    }

    private void onTopicRegistrationRemove() {
        if (this.deactivationHandler != null) {
            this.deactivationHandler.remove();
        }
        this.active = false;
    }

    protected CollaborationEngine getCollaborationEngine() {
        return this.collaborationEngine;
    }

    public UserInfo getLocalUser() {
        return this.localUser;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void close() {
        if (this.topicRegistration != null) {
            this.topicRegistration.remove();
            this.topicRegistration = null;
        }
    }

    @FunctionalInterface
    public static interface ActivationHandler
    extends Serializable {
        public Registration onActivation();
    }
}

