/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vaadin.collaborationengine.CollaborationBinder;
import com.vaadin.collaborationengine.JsonConversionException;
import com.vaadin.collaborationengine.UserInfo;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public class JsonUtil {
    static final String CHANGE_TYPE = "type";
    static final String CHANGE_NAME = "name";
    static final String CHANGE_KEY = "key";
    static final String CHANGE_VALUE = "value";
    static final String CHANGE_OLD_VALUE = "old-value";
    static final String CHANGE_EXPECTED_ID = "expected-id";
    static final String CHANGE_EXPECTED_VALUE = "expected-value";
    static final String CHANGE_TYPE_PUT = "m-put";
    static final String CHANGE_TYPE_APPEND = "l-append";
    static final String CHANGE_TYPE_LIST_SET = "l-set";
    static final String CHANGE_ITEM = "item";
    public static final String CHANGE_NODE_ID = "node-id";
    public static final String CHANGE_NODE_JOIN = "node-join";
    public static final String CHANGE_NODE_LEAVE = "node-leave";
    public static final String CHANGE_SCOPE_OWNER = "scope-owner";
    public static final TypeReference<List<UserInfo>> LIST_USER_TYPE_REF = new TypeReference<List<UserInfo>>(){};
    public static final TypeReference<List<CollaborationBinder.FocusedEditor>> EDITORS_TYPE_REF = new TypeReference<List<CollaborationBinder.FocusedEditor>>(){};
    private static final ObjectMapper mapper = new ObjectMapper();

    private JsonUtil() {
    }

    static ObjectMapper getObjectMapper() {
        return mapper;
    }

    static JsonNode toJsonNode(Object value) {
        try {
            return mapper.valueToTree(value);
        }
        catch (IllegalArgumentException e) {
            throw new JsonConversionException("Failed to encode the object to JSON node. Make sure the value contains a supported type.", e);
        }
    }

    static <T> T toInstance(JsonNode jsonNode, Class<T> type) {
        if (jsonNode == null) {
            return null;
        }
        try {
            return (T)mapper.treeToValue((TreeNode)jsonNode, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonConversionException("Failed to parse the JSON node to " + type.getName(), e);
        }
    }

    static <T> Function<JsonNode, T> fromJsonConverter(Class<T> type) {
        Objects.requireNonNull(type, "The type can't be null");
        return jsonNode -> JsonUtil.toInstance(jsonNode, type);
    }

    static <T> T toInstance(JsonNode jsonNode, TypeReference<T> type) {
        Objects.requireNonNull(type, "The type reference cannot be null");
        return (T)JsonUtil.toInstance(jsonNode, type.getType());
    }

    static <T> Function<JsonNode, T> fromJsonConverter(TypeReference<T> type) {
        return jsonNode -> JsonUtil.toInstance(jsonNode, type);
    }

    static Object toInstance(JsonNode jsonNode, Type type) {
        if (jsonNode == null) {
            return null;
        }
        JavaType javaType = mapper.getTypeFactory().constructType(type);
        try {
            return mapper.readValue(mapper.treeAsTokens((TreeNode)jsonNode), javaType);
        }
        catch (IOException e) {
            throw new JsonConversionException("Failed to parse the JSON node to " + javaType.getTypeName(), e);
        }
    }

    static UUID toUUID(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode.isNull()) {
            return null;
        }
        return UUID.fromString(jsonNode.asText());
    }

    static ObjectNode createPutChange(String name, String key, Object expectedValue, Object value, UUID scopeOwnerId) {
        ObjectNode change = mapper.createObjectNode();
        change.put(CHANGE_TYPE, CHANGE_TYPE_PUT);
        change.put(CHANGE_NAME, name);
        change.put(CHANGE_KEY, key);
        change.set(CHANGE_VALUE, JsonUtil.toJsonNode(value));
        if (scopeOwnerId != null) {
            change.put(CHANGE_SCOPE_OWNER, scopeOwnerId.toString());
        }
        if (expectedValue != null) {
            change.set(CHANGE_EXPECTED_VALUE, JsonUtil.toJsonNode(expectedValue));
        }
        return change;
    }

    static ObjectNode createAppendChange(String name, Object item, UUID scopeOwnerId) {
        ObjectNode change = mapper.createObjectNode();
        change.put(CHANGE_TYPE, CHANGE_TYPE_APPEND);
        change.put(CHANGE_NAME, name);
        change.set(CHANGE_ITEM, JsonUtil.toJsonNode(item));
        if (scopeOwnerId != null) {
            change.put(CHANGE_SCOPE_OWNER, scopeOwnerId.toString());
        }
        return change;
    }

    static ObjectNode createListSetChange(String name, String id, Object value, UUID scopeOwnerId) {
        ObjectNode change = mapper.createObjectNode();
        change.put(CHANGE_TYPE, CHANGE_TYPE_LIST_SET);
        change.put(CHANGE_NAME, name);
        change.put(CHANGE_KEY, id);
        change.set(CHANGE_VALUE, JsonUtil.toJsonNode(value));
        if (scopeOwnerId != null) {
            change.put(CHANGE_SCOPE_OWNER, scopeOwnerId.toString());
        }
        return change;
    }

    public static ObjectNode createNodeJoin(UUID id) {
        ObjectNode payload = mapper.createObjectNode();
        payload.put(CHANGE_TYPE, CHANGE_NODE_JOIN);
        payload.put(CHANGE_NODE_ID, id.toString());
        return payload;
    }

    public static ObjectNode createNodeLeave(UUID id) {
        ObjectNode payload = mapper.createObjectNode();
        payload.put(CHANGE_TYPE, CHANGE_NODE_LEAVE);
        payload.put(CHANGE_NODE_ID, id.toString());
        return payload;
    }

    static {
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

