/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.collaborationengine.Backend;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.EntryList;
import com.vaadin.collaborationengine.EventUtil;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.ListChange;
import com.vaadin.collaborationengine.ListChangeType;
import com.vaadin.collaborationengine.MapChange;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Topic {
    private final String id;
    private final CollaborationEngine collaborationEngine;
    private final Map<String, Map<String, Entry>> namedMapData = new HashMap<String, Map<String, Entry>>();
    private final Map<String, EntryList> namedListData = new HashMap<String, EntryList>();
    final Map<String, Duration> mapExpirationTimeouts = new HashMap<String, Duration>();
    final Map<String, Duration> listExpirationTimeouts = new HashMap<String, Duration>();
    private Instant lastDisconnected;
    private final List<SerializableBiConsumer<UUID, ChangeDetails>> changeListeners = new ArrayList<SerializableBiConsumer<UUID, ChangeDetails>>();
    private final Map<UUID, SerializableConsumer<ChangeResult>> changeResultTrackers = new ConcurrentHashMap<UUID, SerializableConsumer<ChangeResult>>();
    private final List<UUID> backendNodes = new ArrayList<UUID>();
    private final Backend.EventLog eventLog;
    private boolean leader;
    private int changeCount;

    Topic(String id, CollaborationEngine collaborationEngine, Backend.EventLog eventLog) {
        this.id = id;
        this.collaborationEngine = collaborationEngine;
        this.eventLog = eventLog;
        Backend backend = this.getBackend();
        backend.getMembershipEventLog().subscribe(null, (changeId, changeNode) -> {
            String type = changeNode.get("type").asText();
            if ("node-leave".equals(type)) {
                this.handleNodeLeave((ObjectNode)changeNode);
            }
        });
        backend.loadLatestSnapshot(id).thenAccept(this::initializeFromSnapshot);
    }

    UUID getCurrentNodeId() {
        return this.getBackend().getNodeId();
    }

    private Backend getBackend() {
        return this.collaborationEngine.getConfiguration().getBackend();
    }

    private void initializeFromSnapshot(ObjectNode snapshot) {
        if (snapshot != null) {
            UUID latestChange = JsonUtil.toUUID(snapshot.get("latest"));
            this.loadSnapshot(new Snapshot(snapshot));
            this.eventLog.subscribe(latestChange, this::applyChange);
        } else {
            this.eventLog.subscribe(null, this::applyChange);
        }
        ObjectNode nodeEvent = JsonUtil.createNodeJoin(this.getCurrentNodeId());
        this.eventLog.submitEvent(UUID.randomUUID(), nodeEvent);
    }

    synchronized void handleNodeLeave(ObjectNode changeNode) {
        UUID nodeId = UUID.fromString(changeNode.get("node-id").asText());
        Backend backend = this.collaborationEngine.getConfiguration().getBackend();
        this.backendNodes.remove(nodeId);
        if (!this.backendNodes.isEmpty() && this.backendNodes.get(0).equals(backend.getNodeId())) {
            this.becomeLeader();
        }
        if (this.leader) {
            this.cleanupStaleEntries(nodeId::equals);
        }
    }

    private void cleanupStaleEntries(Predicate<UUID> isStale) {
        this.namedMapData.entrySet().stream().flatMap(map -> ((Map)map.getValue()).entrySet().stream().filter(entry -> isStale.test(((Entry)entry.getValue()).scopeOwnerId)).map(entry -> {
            ObjectNode change = JsonUtil.createPutChange((String)map.getKey(), (String)entry.getKey(), null, null, null);
            change.put("expected-id", ((Entry)entry.getValue()).revisionId.toString());
            return change;
        })).collect(Collectors.toList()).forEach(change -> this.eventLog.submitEvent(UUID.randomUUID(), (ObjectNode)change));
        this.namedListData.entrySet().stream().flatMap(list -> ((EntryList)list.getValue()).stream().filter(entry -> isStale.test(entry.scopeOwnerId)).map(entry -> {
            ObjectNode change = JsonUtil.createListSetChange((String)list.getKey(), entry.id.toString(), null, null);
            change.put("expected-id", entry.revisionId.toString());
            return change;
        })).collect(Collectors.toList()).forEach(change -> this.eventLog.submitEvent(UUID.randomUUID(), (ObjectNode)change));
    }

    Registration subscribeToChange(SerializableBiConsumer<UUID, ChangeDetails> changeListener) {
        this.clearExpiredData();
        this.changeListeners.add(changeListener);
        return Registration.combine((Registration[])new Registration[]{(Registration & Serializable)() -> this.changeListeners.remove(changeListener), this::updateLastDisconnected});
    }

    private void clearExpiredData() {
        Clock clock = this.collaborationEngine.getClock();
        if (this.lastDisconnected != null) {
            Instant now = clock.instant();
            this.mapExpirationTimeouts.forEach((name, timeout) -> {
                if (now.isAfter(this.lastDisconnected.plus((TemporalAmount)timeout)) && this.namedMapData.containsKey(name)) {
                    this.namedMapData.get(name).clear();
                }
            });
            this.listExpirationTimeouts.forEach((name, timeout) -> {
                if (now.isAfter(this.lastDisconnected.plus((TemporalAmount)timeout))) {
                    this.getList((String)name).ifPresent(EntryList::clear);
                }
            });
        }
        this.lastDisconnected = null;
    }

    private void updateLastDisconnected() {
        if (this.changeListeners.isEmpty()) {
            this.lastDisconnected = this.collaborationEngine.getClock().instant();
        }
    }

    Stream<MapChange> getMapData(String mapName) {
        Map<String, Entry> mapData = this.namedMapData.get(mapName);
        if (mapData == null) {
            return Stream.empty();
        }
        return mapData.entrySet().stream().map(entry -> new MapChange(mapName, (String)entry.getKey(), null, ((Entry)entry.getValue()).data, null));
    }

    JsonNode getMapValue(String mapName, String key) {
        Map<String, Entry> map = this.namedMapData.get(mapName);
        if (map == null || !map.containsKey(key)) {
            return null;
        }
        return map.get((Object)key).data.deepCopy();
    }

    synchronized ChangeResult applyChange(UUID trackingId, ObjectNode change) {
        ChangeDetails details;
        String type;
        ++this.changeCount;
        switch (type = change.get("type").asText()) {
            case "m-put": {
                details = this.applyMapChange(trackingId, change);
                break;
            }
            case "l-append": {
                details = this.applyListAppend(trackingId, change);
                break;
            }
            case "l-set": {
                details = this.applyListSet(trackingId, change);
                break;
            }
            case "node-join": {
                UUID nodeId = UUID.fromString(change.get("node-id").asText());
                if (this.backendNodes.isEmpty() && this.collaborationEngine.getConfiguration().getBackend().getNodeId().equals(nodeId)) {
                    this.becomeLeader();
                }
                this.backendNodes.add(nodeId);
                return ChangeResult.ACCEPTED;
            }
            default: {
                throw new UnsupportedOperationException("Type '" + type + "' is not a supported change type");
            }
        }
        ChangeResult result = details != null ? ChangeResult.ACCEPTED : ChangeResult.REJECTED;
        SerializableConsumer<ChangeResult> changeResultTracker = this.changeResultTrackers.remove(trackingId);
        if (changeResultTracker != null) {
            changeResultTracker.accept((Object)result);
        }
        if (ChangeResult.ACCEPTED.equals((Object)result)) {
            EventUtil.fireEvents(this.changeListeners, listener -> listener.accept((Object)trackingId, (Object)details), true);
        }
        if (this.leader && this.changeCount % 100 == 0) {
            this.getBackend().submitSnapshot(this.id, Snapshot.fromTopic(this, trackingId).toObjectNode());
        }
        return result;
    }

    void loadSnapshot(Snapshot snapshot) {
        if (!(this.namedListData.isEmpty() && this.namedMapData.isEmpty() && this.backendNodes.isEmpty())) {
            throw new IllegalStateException("You can only load snapshots for empty topics");
        }
        this.namedListData.putAll(snapshot.getLists());
        this.namedMapData.putAll(snapshot.getMaps());
        this.backendNodes.addAll(snapshot.getBackendNodes());
    }

    private void becomeLeader() {
        this.leader = true;
        HashSet<UUID> backendNodesCopy = new HashSet<UUID>(this.backendNodes);
        this.cleanupStaleEntries(id -> !backendNodesCopy.contains(id));
    }

    boolean isLeader() {
        return this.leader;
    }

    ChangeDetails applyMapChange(UUID changeId, ObjectNode change) {
        UUID oldChangeId;
        String mapName = change.get("name").asText();
        String key = change.get("key").asText();
        JsonNode expectedValue = change.get("expected-value");
        JsonNode expectedId = change.get("expected-id");
        JsonNode newValue = change.get("value");
        Map map = this.namedMapData.computeIfAbsent(mapName, name -> new HashMap());
        NullNode oldValue = map.containsKey(key) ? ((Entry)map.get((Object)key)).data : NullNode.getInstance();
        UUID uUID = oldChangeId = map.containsKey(key) ? ((Entry)map.get((Object)key)).revisionId : null;
        if (expectedId != null && !Objects.equals(oldChangeId, JsonUtil.toUUID(expectedId))) {
            return null;
        }
        if (expectedValue != null && !Objects.equals(oldValue, expectedValue)) {
            return null;
        }
        if (newValue instanceof NullNode) {
            map.remove(key);
        } else {
            map.put(key, new Entry(changeId, newValue.deepCopy(), JsonUtil.toUUID(change.get("scope-owner"))));
        }
        return new MapChange(mapName, key, (JsonNode)oldValue, newValue, JsonUtil.toUUID(expectedId));
    }

    ChangeDetails applyListAppend(UUID id, ObjectNode change) {
        String listName = change.get("name").asText();
        JsonNode item = change.get("item");
        UUID scopeOwnerId = JsonUtil.toUUID(change.get("scope-owner"));
        EntryList.ListEntrySnapshot insertedEntry = this.getOrCreateList(listName).insertLast(id, item, id, scopeOwnerId);
        return new ListChange(listName, ListChangeType.INSERT, id, null, item, null, insertedEntry.prev, null, null, null);
    }

    private ChangeDetails applyListSet(UUID trackingId, ObjectNode change) {
        String listName = change.get("name").asText();
        UUID key = JsonUtil.toUUID(change.get("key"));
        JsonNode newValue = change.get("value");
        UUID expectedId = JsonUtil.toUUID(change.get("expected-id"));
        EntryList list = this.getOrCreateList(listName);
        EntryList.ListEntrySnapshot entry = list.getEntry(key);
        if (entry == null) {
            return null;
        }
        if (expectedId != null && !Objects.equals(entry.revisionId, expectedId)) {
            return null;
        }
        if (newValue.isNull()) {
            list.remove(key);
            return new ListChange(listName, ListChangeType.SET, key, entry.value, null, entry.prev, null, entry.next, null, expectedId);
        }
        JsonNode oldValue = entry.value;
        UUID scopeOwnerId = JsonUtil.toUUID(change.get("scope-owner"));
        list.setValue(key, newValue, trackingId, scopeOwnerId);
        return new ListChange(listName, ListChangeType.SET, key, oldValue, newValue, entry.prev, entry.prev, entry.next, entry.next, expectedId);
    }

    Stream<ListChange> getListChanges(String listName) {
        return this.getListItems(listName).map(item -> new ListChange(listName, ListChangeType.INSERT, item.id, null, item.value, null, item.prev, null, null, null));
    }

    Stream<EntryList.ListEntrySnapshot> getListItems(String listName) {
        return this.getList(listName).map(EntryList::stream).orElseGet(Stream::empty);
    }

    JsonNode getListValue(String listName, UUID key) {
        return this.getList(listName).map(list -> list.getValue(key)).orElse(null);
    }

    private EntryList getOrCreateList(String listName) {
        return this.namedListData.computeIfAbsent(listName, name -> new EntryList());
    }

    private Optional<EntryList> getList(String listName) {
        return Optional.ofNullable(this.namedListData.get(listName));
    }

    void setChangeResultTracker(UUID id, SerializableConsumer<ChangeResult> changeResultTracker) {
        SerializableConsumer<ChangeResult> oldTracker = this.changeResultTrackers.putIfAbsent(id, changeResultTracker);
        if (oldTracker != null) {
            throw new IllegalStateException("Cannot set a change-result tracker for an id with one already set");
        }
    }

    boolean hasChangeListeners() {
        return !this.changeListeners.isEmpty();
    }

    static class Snapshot {
        private static final TypeReference<Map<String, EntryList>> LISTS_TYPE = new TypeReference<Map<String, EntryList>>(){};
        private static final TypeReference<Map<String, Map<String, Entry>>> MAPS_TYPE = new TypeReference<Map<String, Map<String, Entry>>>(){};
        private static final TypeReference<List<UUID>> BACKEND_NODES_TYPE = new TypeReference<List<UUID>>(){};
        private static final String LATEST = "latest";
        private static final String LISTS = "lists";
        private static final String MAPS = "maps";
        private static final String BACKEND_NODES = "backend-nodes";
        private final ObjectNode objectNode;

        Snapshot(ObjectNode objectNode) {
            this.objectNode = Objects.requireNonNull(objectNode);
        }

        static Snapshot fromTopic(Topic topic, UUID latestChangeId) {
            ObjectNode objectNode = JsonUtil.getObjectMapper().createObjectNode();
            objectNode.put(LATEST, latestChangeId.toString());
            objectNode.set(LISTS, JsonUtil.toJsonNode(topic.namedListData));
            objectNode.set(MAPS, JsonUtil.toJsonNode(topic.namedMapData));
            objectNode.set(BACKEND_NODES, JsonUtil.toJsonNode(topic.backendNodes));
            return new Snapshot(objectNode);
        }

        ObjectNode toObjectNode() {
            return this.objectNode;
        }

        Map<String, EntryList> getLists() {
            return JsonUtil.toInstance(this.objectNode.get(LISTS), LISTS_TYPE);
        }

        Map<String, Map<String, Entry>> getMaps() {
            return JsonUtil.toInstance(this.objectNode.get(MAPS), MAPS_TYPE);
        }

        List<UUID> getBackendNodes() {
            return JsonUtil.toInstance(this.objectNode.get(BACKEND_NODES), BACKEND_NODES_TYPE);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    static class Entry {
        final UUID revisionId;
        final JsonNode data;
        final UUID scopeOwnerId;

        @JsonCreator
        public Entry(@JsonProperty(value="id") UUID id, @JsonProperty(value="data") JsonNode data, @JsonProperty(value="scopeOwnerId") UUID scopeOwnerId) {
            this.revisionId = id;
            this.data = data;
            this.scopeOwnerId = scopeOwnerId;
        }
    }

    static interface ChangeDetails {
    }

    static enum ChangeResult {
        ACCEPTED,
        REJECTED;

    }
}

