/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.EntryScope;
import com.vaadin.collaborationengine.ListKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListOperation {
    private final Object value;
    private final boolean before;
    private final ListKey referenceKey;
    private final Map<ListKey, ListKey> conditions = new HashMap<ListKey, ListKey>();
    private EntryScope scope = EntryScope.TOPIC;
    private Boolean empty;

    public static ListOperation insertFirst(Object value) {
        Objects.requireNonNull(value);
        return new ListOperation(value, false, null);
    }

    public static ListOperation insertLast(Object value) {
        Objects.requireNonNull(value);
        return new ListOperation(value, true, null);
    }

    public static ListOperation insertBefore(ListKey before, Object value) {
        Objects.requireNonNull(before);
        Objects.requireNonNull(value);
        return new ListOperation(value, true, before);
    }

    public static ListOperation insertAfter(ListKey after, Object value) {
        Objects.requireNonNull(after);
        Objects.requireNonNull(value);
        return new ListOperation(value, false, after);
    }

    public static ListOperation insertBetween(ListKey prev, ListKey next, Object value) {
        Objects.requireNonNull(prev);
        Objects.requireNonNull(next);
        Objects.requireNonNull(value);
        return ListOperation.insertAfter(prev, value).ifNext(prev, next);
    }

    private ListOperation(Object value, boolean before, ListKey referenceKey) {
        this.value = value;
        this.before = before;
        this.referenceKey = referenceKey;
    }

    public ListOperation withScope(EntryScope scope) {
        this.scope = Objects.requireNonNull(scope);
        return this;
    }

    public ListOperation ifNext(ListKey key, ListKey nextKey) {
        Objects.requireNonNull(key);
        if (this.conditions.containsKey(key)) {
            throw new IllegalStateException("A requirement for the value after this key is already set");
        }
        this.conditions.put(key, nextKey);
        return this;
    }

    public ListOperation ifLast(ListKey key) {
        Objects.requireNonNull(key);
        return this.ifNext(key, null);
    }

    public ListOperation ifPrev(ListKey key, ListKey prevKey) {
        Objects.requireNonNull(key);
        if (this.conditions.containsValue(key)) {
            throw new IllegalStateException("A requirement for the value before this key is already set");
        }
        this.conditions.put(prevKey, key);
        return this;
    }

    public ListOperation ifFirst(ListKey key) {
        Objects.requireNonNull(key);
        return this.ifPrev(key, null);
    }

    public ListOperation ifEmpty() {
        if (Boolean.FALSE.equals(this.empty)) {
            throw new IllegalStateException("This operation already requires the list not to be empty.");
        }
        this.empty = true;
        return this;
    }

    public ListOperation ifNotEmpty() {
        if (Boolean.TRUE.equals(this.empty)) {
            throw new IllegalStateException("This operation already requires the list to be empty.");
        }
        this.empty = false;
        return this;
    }

    Object getValue() {
        return this.value;
    }

    boolean isBefore() {
        return this.before;
    }

    ListKey getReferenceKey() {
        return this.referenceKey;
    }

    EntryScope getScope() {
        return this.scope;
    }

    Map<ListKey, ListKey> getConditions() {
        return Collections.unmodifiableMap(this.conditions);
    }

    Boolean getEmpty() {
        return this.empty;
    }
}

