/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationAvatarGroup;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationMessage;
import com.vaadin.collaborationengine.CollaborationMessagePersister;
import com.vaadin.collaborationengine.CollaborationMessageSubmitter;
import com.vaadin.collaborationengine.ComponentConnectionContext;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.MessageManager;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.messages.MessageList;
import com.vaadin.flow.component.messages.MessageListItem;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CollaborationMessageList
extends Composite<MessageList>
implements HasSize,
HasStyle {
    private final SerializableSupplier<CollaborationEngine> ceSupplier;
    private CollaborationAvatarGroup.ImageProvider imageProvider;
    private final UserInfo localUser;
    private CollaborationMessageSubmitter submitter;
    private Registration submitterRegistration;
    private MessageConfigurator messageConfigurator;
    private MessageManager messageManager;
    private final CollaborationMessagePersister persister;
    private final List<CollaborationMessage> messageCache = new ArrayList<CollaborationMessage>();

    public CollaborationMessageList(UserInfo localUser, String topicId) {
        this(localUser, topicId, null, (SerializableSupplier<CollaborationEngine>)((SerializableSupplier & Serializable)CollaborationEngine::getInstance));
    }

    public CollaborationMessageList(UserInfo localUser, String topicId, CollaborationMessagePersister persister) {
        this(localUser, topicId, persister, (SerializableSupplier<CollaborationEngine>)((SerializableSupplier & Serializable)CollaborationEngine::getInstance));
    }

    CollaborationMessageList(UserInfo localUser, String topicId, CollaborationMessagePersister persister, SerializableSupplier<CollaborationEngine> ceSupplier) {
        this.localUser = Objects.requireNonNull(localUser, "User cannot be null");
        this.ceSupplier = ceSupplier;
        this.persister = persister;
        this.setTopic(topicId);
    }

    public void setTopic(String topicId) {
        String currentTopic;
        String string = currentTopic = this.messageManager != null ? this.messageManager.getTopicId() : null;
        if (Objects.equals(currentTopic, topicId)) {
            return;
        }
        if (this.messageManager != null) {
            this.messageManager.close();
            this.messageManager = null;
            this.unregisterSubmitter();
            this.messageCache.clear();
            this.refreshMessages();
        }
        if (topicId != null) {
            this.messageManager = new MessageManager((ConnectionContext)new ComponentConnectionContext((Component)this), this.localUser, topicId, this.persister, this.ceSupplier);
            this.messageManager.setMessageHandler(context -> {
                CollaborationMessage message = context.getMessage();
                this.messageCache.add(message);
                this.refreshMessages();
            });
            this.messageManager.setActivationHandler(this::onManagerActivation);
        }
    }

    public void setSubmitter(CollaborationMessageSubmitter submitter) {
        this.unregisterSubmitter();
        this.submitter = submitter;
        if (this.messageManager != null) {
            this.messageManager.setActivationHandler(this::onManagerActivation);
        }
    }

    private Registration onManagerActivation() {
        this.registerSubmitter();
        return (Registration & Serializable)() -> {
            this.unregisterSubmitter();
            this.refreshMessages();
        };
    }

    private void registerSubmitter() {
        if (this.submitter != null) {
            this.submitterRegistration = this.submitter.onActivation(this::appendMessage);
            Objects.requireNonNull(this.submitterRegistration, "The submitter should return a non-null registration object");
        }
    }

    private void unregisterSubmitter() {
        if (this.submitterRegistration != null) {
            this.submitterRegistration.remove();
            this.submitterRegistration = null;
        }
    }

    private CollaborationEngine getCollaborationEngine() {
        return (CollaborationEngine)this.ceSupplier.get();
    }

    void appendMessage(String text) {
        Objects.requireNonNull(text, "Cannot append a null message");
        CollaborationMessage message = new CollaborationMessage(this.localUser, text, this.getCollaborationEngine().getClock().instant());
        this.messageManager.submit(message);
    }

    public void setImageProvider(CollaborationAvatarGroup.ImageProvider imageProvider) {
        this.imageProvider = imageProvider;
        this.refreshMessages();
    }

    public CollaborationAvatarGroup.ImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public void setMessageConfigurator(MessageConfigurator messageConfigurator) {
        this.messageConfigurator = messageConfigurator;
        this.refreshMessages();
    }

    public MessageConfigurator getMessageConfigurator() {
        return this.messageConfigurator;
    }

    private void refreshMessages() {
        List messageListItems = this.messageCache.stream().map(this::convertToMessageListItem).collect(Collectors.toList());
        ((MessageList)this.getContent()).setItems(messageListItems);
    }

    private MessageListItem convertToMessageListItem(CollaborationMessage message) {
        MessageListItem messageListItem = new MessageListItem(message.getText(), message.getTime(), message.getUser().getName());
        if (this.imageProvider == null) {
            messageListItem.setUserImage(message.getUser().getImage());
        } else {
            messageListItem.setUserImageResource(this.imageProvider.getImageResource(message.getUser()));
        }
        messageListItem.setUserAbbreviation(message.getUser().getAbbreviation());
        messageListItem.setUserColorIndex(Integer.valueOf(this.getCollaborationEngine().getUserColorIndex(message.getUser())));
        if (this.messageConfigurator != null) {
            this.messageConfigurator.configureMessage(messageListItem, message.getUser());
        }
        return messageListItem;
    }

    static {
        UsageStatistics.markAsUsed((String)"vaadin-collaboration-engine/CollaborationMessageList", (String)"6.1");
    }

    @FunctionalInterface
    public static interface MessageConfigurator {
        public void configureMessage(MessageListItem var1, UserInfo var2);
    }
}

