/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.ActionDispatcher;
import com.vaadin.collaborationengine.ActivationHandler;
import com.vaadin.collaborationengine.AsyncRegistration;
import com.vaadin.collaborationengine.BeaconHandler;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.ExecutionQueue;
import com.vaadin.collaborationengine.ServiceDestroyDelegate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DeadlockDetectingCompletableFuture;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class ComponentConnectionContext
implements ConnectionContext {
    private final Map<Component, Registration> componentListeners = new HashMap<Component, Registration>();
    private final Set<Component> attachedComponents = new HashSet<Component>();
    private volatile UI ui;
    private final transient ExecutionQueue inbox = new ExecutionQueue();
    private final transient ExecutionQueue shutdownCommands = new ExecutionQueue();
    private final ActionDispatcher actionDispatcher = new ActionDispatcherImpl();
    private final AtomicReference<State> state = new AtomicReference<State>(State.INACTIVE);
    private transient Consumer<ActionDispatcher> activationHandler;
    private transient Executor backgroundRunner;
    private transient Registration beaconListener;
    private transient Registration destroyListener;
    private static AtomicBoolean pushWarningShown = new AtomicBoolean(false);

    public ComponentConnectionContext() {
    }

    public ComponentConnectionContext(Component component) {
        this.addComponent(component);
    }

    public void addComponent(Component component) {
        Objects.requireNonNull(component, "Component can't be null.");
        if (!this.componentListeners.containsKey(component)) {
            Registration attachRegistration = component.addAttachListener((ComponentEventListener & Serializable)event -> this.markAsAttached(event.getUI(), event.getSource()));
            Registration detachRegistration = component.addDetachListener((ComponentEventListener & Serializable)event -> this.markAsDetached(event.getSource()));
            this.componentListeners.put(component, Registration.combine((Registration[])new Registration[]{attachRegistration, detachRegistration}));
            component.getUI().ifPresent(componentUi -> this.markAsAttached((UI)componentUi, component));
        }
    }

    public void removeComponent(Component component) {
        Objects.requireNonNull(component, "Component can't be null.");
        Registration registration = this.componentListeners.remove(component);
        if (registration != null) {
            registration.remove();
            this.markAsDetached(component);
        }
    }

    private void markAsAttached(UI componentUi, Component component) {
        if (this.attachedComponents.add(component)) {
            if (this.attachedComponents.size() == 1) {
                this.ui = componentUi;
                ComponentConnectionContext.checkForPush(this.ui);
                String beaconPath = CollaborationEngine.getInstance(this.ui.getSession().getService()).getConfiguration().getBeaconPathProperty();
                BeaconHandler beaconHandler = BeaconHandler.ensureInstalled(this.ui, beaconPath);
                this.beaconListener = beaconHandler.addListener(this::deactivateConnection);
                ServiceDestroyDelegate destroyDelegate = ServiceDestroyDelegate.ensureInstalled(this.ui);
                this.destroyListener = destroyDelegate.addListener((ServiceDestroyListener & Serializable)event -> this.deactivateConnection());
                this.flushPendingActionsIfActive();
                if (this.activationHandler != null) {
                    this.activate();
                }
            } else if (componentUi != this.ui) {
                throw new IllegalStateException("All components in this connection context must be associated with the same UI.");
            }
        }
    }

    private void markAsDetached(Component component) {
        if (this.attachedComponents.remove(component) && this.attachedComponents.isEmpty()) {
            this.deactivateConnection();
        }
    }

    @Override
    public Registration init(ActivationHandler activationHandler, Executor backgroundRunner) {
        if (this.activationHandler != null) {
            throw new IllegalStateException("This context has already been initialized");
        }
        this.activationHandler = (Consumer)((Object)Objects.requireNonNull(activationHandler, "Activation handler cannot be null"));
        this.backgroundRunner = Objects.requireNonNull(backgroundRunner, "Background runner cannot be null");
        if (this.ui != null) {
            this.activate();
        }
        CompletableFuture<Void> deactivationFuture = new CompletableFuture<Void>();
        return new AsyncRegistration(deactivationFuture, (Registration & Serializable)() -> {
            if (this.state.get() == State.INACTIVE) {
                deactivationFuture.complete(null);
            } else {
                this.shutdownCommands.add((Command & Serializable)() -> deactivationFuture.complete(null));
            }
            this.componentListeners.values().forEach(Registration::remove);
            this.componentListeners.clear();
            this.attachedComponents.clear();
            this.deactivateConnection();
        });
    }

    private void activate() {
        if (this.activationHandler != null && this.state.getAndSet(State.ACTIVE) != State.ACTIVE) {
            this.activationHandler.accept(this.actionDispatcher);
        }
    }

    private void deactivateConnection() {
        if (this.beaconListener != null) {
            this.beaconListener.remove();
            this.beaconListener = null;
        }
        if (this.destroyListener != null) {
            this.destroyListener.remove();
            this.destroyListener = null;
        }
        if (this.activationHandler != null && this.ui != null && this.state.compareAndSet(State.ACTIVE, State.INACTIVATING)) {
            this.activationHandler.accept(null);
            if (this.inbox.isEmpty()) {
                this.inactivateIfDeactivating();
            }
        }
    }

    private void inactivateIfDeactivating() {
        if (this.state.compareAndSet(State.INACTIVATING, State.INACTIVE)) {
            this.ui = null;
            this.shutdownCommands.runPendingCommands();
        }
    }

    private void flushPendingActionsIfActive() {
        UI localUI = this.ui;
        if (localUI == null || this.backgroundRunner == null) {
            return;
        }
        VaadinSession session = localUI.getSession();
        this.backgroundRunner.execute(() -> session.access((Command & Serializable)() -> {
            UI currentUI = UI.getCurrent();
            if (currentUI == null) {
                UI.setCurrent((UI)localUI);
            }
            try {
                this.inbox.runPendingCommands();
                this.inactivateIfDeactivating();
            }
            finally {
                if (currentUI == null) {
                    UI.setCurrent(null);
                }
            }
        }));
    }

    private static void checkForPush(UI ui) {
        if (!ComponentConnectionContext.canPushChanges(ui) && ComponentConnectionContext.isActivationEnabled(ui)) {
            ui.getPushConfiguration().setPushMode(PushMode.AUTOMATIC);
            boolean warningAlreadyShown = pushWarningShown.getAndSet(true);
            if (!warningAlreadyShown) {
                int flowVersionInVaadin14 = 2;
                String annotationLocation = Version.getMajorVersion() == flowVersionInVaadin14 ? "root layout or individual views" : "AppShellConfigurator class";
                LoggerFactory.getLogger(ComponentConnectionContext.class).warn("Server push has been automatically enabled so updates can be shown immediately. Add @Push annotation on your " + annotationLocation + " to suppress this warning. Set automaticallyActivatePush to false in CollaborationEngineConfiguration if you want to ensure push is not automatically enabled.");
            }
        }
    }

    private static boolean isActivationEnabled(UI ui) {
        CollaborationEngine ce = CollaborationEngine.getInstance(ui.getSession().getService());
        return ce != null ? ce.getConfiguration().isAutomaticallyActivatePush() : true;
    }

    private static boolean canPushChanges(UI ui) {
        return ui.getPushConfiguration().getPushMode().isEnabled() || ui.getPollInterval() > 0;
    }

    class ActionDispatcherImpl
    implements ActionDispatcher {
        ActionDispatcherImpl() {
        }

        @Override
        public void dispatchAction(Command action) {
            ComponentConnectionContext.this.inbox.add(action);
            ComponentConnectionContext.this.flushPendingActionsIfActive();
        }

        @Override
        public <T> CompletableFuture<T> createCompletableFuture() {
            UI localUI = ComponentConnectionContext.this.ui;
            if (localUI == null) {
                throw new IllegalStateException("The topic connection within this context maybe deactivated.Make sure the context has at least one component attached to the UI.");
            }
            return new DeadlockDetectingCompletableFuture(localUI.getSession());
        }
    }

    private static enum State {
        ACTIVE,
        INACTIVATING,
        INACTIVE;

    }
}

