/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter.i18n;

import com.vaadin.controlcenter.starter.i18n.ControlCenterI18NProperties;
import com.vaadin.controlcenter.starter.i18n.ControlCenterI18NProvider;
import com.vaadin.controlcenter.starter.i18n.I18NPreviewFilter;
import com.vaadin.controlcenter.starter.i18n.I18NPreviewServiceInitListener;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.spring.SpringBootAutoConfiguration;
import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.servlet.Filter;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.AbstractApplicationContext;

@AutoConfiguration
@AutoConfigureBefore(value={SpringBootAutoConfiguration.class})
@EnableConfigurationProperties(value={ControlCenterI18NProperties.class})
public class ControlCenterI18NConfiguration {
    @Bean
    @ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
    static BeanPostProcessor i18nProviderBeanPostProcessor(final KubernetesClient client, final AbstractApplicationContext applicationContext) {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
                if (bean instanceof I18NProvider) {
                    I18NProvider i18NProvider = (I18NProvider)bean;
                    ControlCenterI18NProvider ccI18NProvider = new ControlCenterI18NProvider(client, i18NProvider);
                    applicationContext.addApplicationListener((ApplicationListener)ccI18NProvider);
                    return ccI18NProvider;
                }
                return bean;
            }
        };
    }

    @Bean
    @ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
    FilterRegistrationBean<I18NPreviewFilter> i18nPreviewFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new I18NPreviewFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }

    @Bean
    @ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
    I18NPreviewServiceInitListener i18NPreviewServiceInitListener() {
        return new I18NPreviewServiceInitListener();
    }
}

