/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter.idm;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.web.filter.GenericFilterBean;

class RefreshTokenFilter
extends GenericFilterBean {
    private final OAuth2AuthorizedClientService clientService;

    public RefreshTokenFilter(OAuth2AuthorizedClientService clientService) {
        this.clientService = clientService;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        OAuth2AuthenticationToken token;
        OAuth2AuthorizedClient client;
        OAuth2AccessToken accessToken;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof OAuth2AuthenticationToken && Objects.requireNonNull((accessToken = (client = this.clientService.loadAuthorizedClient((token = (OAuth2AuthenticationToken)authentication).getAuthorizedClientRegistrationId(), token.getName())).getAccessToken()).getExpiresAt()).isBefore(Instant.now())) {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

