/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.controlcenter.starter.i18n;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServiceInitListener;
import java.io.Serializable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class I18NPreviewServiceInitListener
implements VaadinServiceInitListener {
    private static final String I18N_PREVIEW_COOKIE = "i18n-preview";
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    Button moveButton;
    Button exitButton;

    I18NPreviewServiceInitListener() {
    }

    public void serviceInit(ServiceInitEvent serviceInitEvent) {
        this.logger.info("Initializing I18nPreviewService");
        serviceInitEvent.getSource().addUIInitListener((UIInitListener & Serializable)event -> {
            if (!this.isPreviewEnabled()) {
                return;
            }
            UI ui = event.getUI();
            ui.setLocale(VaadinRequest.getCurrent().getLocale());
            Icon downIcon = VaadinIcon.ARROW_DOWN.create();
            Icon upIcon = VaadinIcon.ARROW_UP.create();
            this.moveButton = new Button((Component)upIcon);
            this.moveButton.setAriaLabel("Move notification to top");
            this.moveButton.getStyle().setMargin("0 0 0 0");
            this.exitButton = new Button((Component)VaadinIcon.CLOSE.create());
            this.exitButton.addClickListener((ComponentEventListener & Serializable)e -> {
                String currentLocation = ui.getInternals().getActiveViewLocation().getPath();
                String newLocation = currentLocation + "?i18n-preview=disable";
                ui.getPage().setLocation(newLocation);
            });
            this.exitButton.getStyle().setMargin("0 0 0 0");
            HorizontalLayout layout = new HorizontalLayout(new Component[]{new Text("Control Center translation preview"), this.moveButton, this.exitButton});
            layout.setAlignItems(FlexComponent.Alignment.CENTER);
            Notification notification = new Notification();
            notification.add(new Component[]{layout});
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
            notification.setPosition(Notification.Position.BOTTOM_END);
            this.moveButton.addClickListener((ComponentEventListener & Serializable)e -> {
                if (this.moveButton.getIcon().equals(downIcon)) {
                    notification.setPosition(Notification.Position.BOTTOM_END);
                    this.moveButton.setIcon((Component)upIcon);
                    this.moveButton.setAriaLabel("Move notification to top");
                } else {
                    notification.setPosition(Notification.Position.TOP_END);
                    this.moveButton.setIcon((Component)downIcon);
                    this.moveButton.setAriaLabel("Move notification to bottom");
                }
            });
            ui.add(new Component[]{notification});
            notification.open();
        });
    }

    private boolean isPreviewEnabled() {
        if (VaadinRequest.getCurrent() == null) {
            return false;
        }
        if (VaadinRequest.getCurrent().getCookies() == null) {
            return false;
        }
        return Arrays.stream(VaadinRequest.getCurrent().getCookies()).filter(cookie -> I18N_PREVIEW_COOKIE.equals(cookie.getName())).findFirst().map(cookie -> Boolean.parseBoolean(cookie.getValue())).orElse(false);
    }
}

