package com.vaadin.copilot.communication;

/**
 * Enum for stream response statuses: This enum contains the four steps we go
 * through while responding to the client: </br>
 * 1. Preprocessing finished. </br>
 * 2. Embedding context completed. </br>
 * 3. AI call completed. </br>
 * 4. Postprocessing completed.
 */
public enum StreamResponseEnum {

    VALIDATION(-1, "Validation finished"), //
    PRE_PROCESS(0, "Preprocess finished"), //
    EMBEDDING_CONTEXT(1, "Embedding context retrieval finished"), //
    AI_CALL(2, "AI call finished"), //
    POST_PROCESS(3, "Post-process finished");

    private final int code;
    private final String message;

    StreamResponseEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
