package com.vaadin.copilot.ide;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class OpenComponentInIDE implements CopilotCommand {

    IdeIntegration ideIntegration;
    private final ProjectManager projectManager;

    CopilotIDEPlugin idePlugin;

    public OpenComponentInIDE(ApplicationConfiguration applicationConfiguration,
            ProjectManager projectManager) {
        this.ideIntegration = new IdeIntegration(applicationConfiguration);
        this.projectManager = projectManager;
        this.idePlugin = CopilotIDEPlugin.getInstance();
    }

    @Override
    public boolean handleMessage(String command, JsonObject data,
            DevToolsInterface devToolsInterface) {
        if (command.equals("show-in-ide")) {
            if (data.hasKey("nodeId")) {
                showFlowComponent((int) data.getNumber("uiId"),
                        (int) data.getNumber("nodeId"));
            } else {
                showFile(data.getString("fileName"),
                        (int) data.getNumber("lineNumber"));
            }
            return true;
        }
        return false;
    }

    public void showFlowComponent(int uiId, int nodeId) {
        VaadinSession session = VaadinSession.getCurrent();
        session.access(() -> {
            Element element = session.findElement(uiId, nodeId);
            Optional<Component> c = element.getComponent();
            if (c.isPresent()) {
                ideIntegration.showComponentCreateInIde(c.get());
            } else {
                getLogger().error(
                        "Only component locations are tracked. The given node id refers to an element and not a component");
            }
        });
    }

    public void showFile(String filename, int lineNumber) {
        File file = new File(filename);
        if (!file.toPath().isAbsolute()) {
            try {
                file = new File(projectManager.makeAbsolute(filename));
            } catch (IOException e) {
                getLogger().warn("File not found: " + filename);
                return;
            }
        }

        IdeUtils.openFile(file, lineNumber);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }

}
