package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.SetFontRequest;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;

public class SetFontHandler implements MessageHandler {
    private final HasThemeModifier hasThemeModifier;

    public SetFontHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public BaseResponse handle(JsonObject data) {
        SetFontRequest request = JsonUtils.readToObject(data,
                SetFontRequest.class);
        hasThemeModifier.getThemeModifier().setFont(request.getFontName());

        return BaseResponse.ok();
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.SET_FONT.getValue();
    }
}
