package com.vaadin.copilot.plugins.themeeditor.messages;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import static com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand.CODE_OK;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class BaseResponse implements Serializable {

    private String reqId;

    public BaseResponse() {
    }

    public BaseResponse(String reqId) {
        this.reqId = reqId;
    }

    public String getReqId() {
        return reqId;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public String getCode() {
        return CODE_OK.getValue();
    }

    public static BaseResponse ok() {
        return new BaseResponse();
    }
}
