/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.Optional;

public class JavaClassOrRecordRewriter {
    private static final String DEFAULT_LABEL_AND_VALUE_RECORD_NAME = "LabelAndValue";
    private static final String LABEL_ARG_NAME = "label";
    private static final String VALUE_ARG_NAME = "value";
    private static final String ENABLED_ARG_NAME = "enabled";
    private final CompilationUnit compilationUnit;

    public JavaClassOrRecordRewriter(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public String addOrGetLabelValueEnabledRecordName() {
        return this.getLabelValueRecord().orElseGet(this::addLabelValueRecord);
    }

    private Optional<String> getLabelValueRecord() {
        Optional classOrInterfaceDeclarationOptional = this.compilationUnit.findFirst(ClassOrInterfaceDeclaration.class);
        if (classOrInterfaceDeclarationOptional.isEmpty()) {
            return Optional.empty();
        }
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)classOrInterfaceDeclarationOptional.get();
        return classOrInterfaceDeclaration.getChildNodes().stream().filter(RecordDeclaration.class::isInstance).map(RecordDeclaration.class::cast).filter(recordDeclaration -> {
            Optional label = recordDeclaration.getParameterByName(LABEL_ARG_NAME);
            if (label.isEmpty()) {
                return false;
            }
            Optional value = recordDeclaration.getParameterByName(VALUE_ARG_NAME);
            if (value.isEmpty()) {
                return false;
            }
            Optional enabled = recordDeclaration.getParameterByName(ENABLED_ARG_NAME);
            return enabled.isPresent();
        }).map(NodeWithSimpleName::getNameAsString).findFirst();
    }

    private String addLabelValueRecord() {
        RecordDeclaration recordDeclaration = new RecordDeclaration();
        recordDeclaration.setPublic(true);
        recordDeclaration.setName(DEFAULT_LABEL_AND_VALUE_RECORD_NAME);
        Parameter labelParam = new Parameter();
        labelParam.setType("String");
        labelParam.setName(LABEL_ARG_NAME);
        Parameter valueParam = new Parameter();
        valueParam.setType("String");
        valueParam.setName(VALUE_ARG_NAME);
        Parameter enabledParam = new Parameter();
        enabledParam.setType("boolean");
        enabledParam.setName(ENABLED_ARG_NAME);
        recordDeclaration.setParameters(new NodeList((Node[])new Parameter[]{labelParam, valueParam, enabledParam}));
        ConstructorDeclaration constructorDeclaration = recordDeclaration.addConstructor(new Modifier.Keyword[0]);
        constructorDeclaration.addParameter(labelParam);
        constructorDeclaration.addParameter(valueParam);
        BlockStmt body = constructorDeclaration.getBody();
        body.addStatement((Statement)new ExplicitConstructorInvocationStmt(true, (Expression)new ThisExpr(), new NodeList((Node[])new Expression[]{new NameExpr(LABEL_ARG_NAME), new NameExpr(VALUE_ARG_NAME), new BooleanLiteralExpr(true)})));
        Optional classOptional = this.compilationUnit.findFirst(ClassOrInterfaceDeclaration.class);
        if (classOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find the class to add record");
        }
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)classOptional.get();
        classOrInterfaceDeclaration.getMembers().add((Node)recordDeclaration);
        return DEFAULT_LABEL_AND_VALUE_RECORD_NAME;
    }
}

