/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.dom.Style;
import java.util.List;

public class JavaStyleRewriter {
    public static List<StyleInfo> getStyles(ComponentInfo componentInfo) {
        return JavaRewriterUtil.findCalls(Style.class, componentInfo).stream().map(JavaStyleRewriter::extractStyle).toList();
    }

    private static StyleInfo extractStyle(MethodCallExpr methodCallExpr) {
        String value;
        String setter = methodCallExpr.getNameAsString();
        if (setter.equals("set")) {
            String dashProperty = String.valueOf(JavaRewriterUtil.fromExpression(methodCallExpr.getArgument(0), null));
            String value2 = String.valueOf(JavaRewriterUtil.fromExpression(methodCallExpr.getArgument(1), null));
            return new StyleInfo(dashProperty, value2, true);
        }
        int argCount = methodCallExpr.getArguments().size();
        if (argCount != 1) {
            throw new IllegalArgumentException("Expected styles method call expression to have one argument but was " + argCount + " for " + String.valueOf(methodCallExpr));
        }
        Expression argument = methodCallExpr.getArgument(0);
        if (argument.isFieldAccessExpr()) {
            String fieldName = argument.asFieldAccessExpr().getNameAsString();
            value = fieldName.replace("_", "-").toLowerCase();
        } else if (argument.isStringLiteralExpr()) {
            value = argument.asStringLiteralExpr().getValue();
        } else {
            throw new IllegalArgumentException("Unexpected argument type in style call: " + String.valueOf(methodCallExpr));
        }
        String property = JavaRewriterUtil.getPropertyName(setter);
        return new StyleInfo(property, value, false);
    }

    public record StyleInfo(String property, String value, boolean isDashSeparatedProperty) {
    }
}

