package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;

import java.util.Map;
import java.util.Optional;

/**
 * Class/Record definition related functions for Java Rewriter This class
 * generates a record/class to host data entities used in advanced data
 * components like Grid
 *
 *
 */
public class DataEntityRecordRewriter {
    public static final String DEFAULT_ENTITY_RECORD_NAME = "DataEntity";

    private final CompilationUnit compilationUnit;

    public DataEntityRecordRewriter(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    /**
     * Finds the Record Declaration from given complication unit that has Label,
     * Value and Enabled parameters. Creates one with LabelAndValue name if not
     * found.
     *
     * @return of the record name
     */
    public String addOrGetDataEntityRecordName(Map<String, Object> entityFields,
            String dataEntityRecordName) {
        return addDataEntityRecord(entityFields, dataEntityRecordName);
    }

    /**
     * Creates the Record/Class entity next to the component class
     *
     * @param entityFields
     * @return
     */
    private String addDataEntityRecord(Map<String, Object> entityFields,
            String dataEntityRecordName) {
        RecordDeclaration recordDeclaration = new RecordDeclaration();
        recordDeclaration.setPublic(true);
        recordDeclaration.setName(dataEntityRecordName);
        NodeList<Parameter> params = new NodeList<>();
        NodeList<Expression> args = new NodeList<>();
        for (Map.Entry<String, Object> entry : entityFields.entrySet()) {
            Parameter param = new Parameter();
            param.setType("String");
            param.setName(entry.getKey());
            recordDeclaration.addParameter(param);
            params.add(param);
            args.add(new NameExpr(entry.getKey()));
        }

        Optional<ClassOrInterfaceDeclaration> classOptional = compilationUnit
                .findFirst(ClassOrInterfaceDeclaration.class);
        if (classOptional.isEmpty()) {
            throw new IllegalArgumentException(
                    "Could not find the class to add record");
        }
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = classOptional
                .get();
        classOrInterfaceDeclaration.getMembers().add(recordDeclaration);
        return dataEntityRecordName;
    }
}
