/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.DataEntityRecordRewriter;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.LabelValuePairRecordRewriter;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JavaDataProviderHandler {
    private static final String LABEL_KEY = "label";
    private static final String VALUE_KEY = "value";
    private static final String DISABLED_KEY = "disabled";
    private final JavaRewriter javaRewriter;
    private final ComponentTypeAndSourceLocation typeAndSourceLocation;
    private final File sourceFile;

    public JavaDataProviderHandler(ProjectManager projectManager, ComponentTypeAndSourceLocation typeAndSourceLocation) throws IOException {
        this.typeAndSourceLocation = typeAndSourceLocation;
        ComponentTypeAndSourceLocation parent = typeAndSourceLocation.parent();
        if (parent == null) {
            throw new IllegalArgumentException("Could not find the parent of the component");
        }
        this.sourceFile = projectManager.getSourceFile(parent.createLocation());
        this.javaRewriter = new JavaRewriter(projectManager.readFile(this.sourceFile));
    }

    public static boolean isDataProviderItemChange(ComponentTypeAndSourceLocation componentTypeAndSourceLocation) {
        ComponentTracker.Location createLocation = componentTypeAndSourceLocation.createLocation();
        ComponentTracker.Location attachLocation = componentTypeAndSourceLocation.attachLocation();
        if (createLocation != null && attachLocation != null) {
            return createLocation.className().startsWith("com.vaadin.flow.data.provider") && attachLocation.className().startsWith("com.vaadin.flow.data.provider");
        }
        return false;
    }

    public JavaDataProviderHandlerResult handleSetComponentProperty(String property, String value) {
        if (!LABEL_KEY.equals(property)) {
            throw new IllegalArgumentException("Unknown property" + property);
        }
        ComponentInfo parentInfo = this.javaRewriter.findComponentInfo(this.typeAndSourceLocation.parent());
        Component component = this.typeAndSourceLocation.component();
        Object item = this.getItem(component);
        Optional<MethodCallExpr> setItemsCall = JavaRewriterUtil.findMethodCallStatements(parentInfo).stream().filter(f -> f.getNameAsString().equals("setItems")).findFirst();
        Expression expressionToReplace = setItemsCall.isPresent() ? this.findItemExpression((Expression)setItemsCall.get(), item) : this.findItemExpression((Expression)parentInfo.objectCreationExpr(), item);
        if (expressionToReplace == null) {
            throw new IllegalArgumentException("Could not find node to replace");
        }
        if (expressionToReplace.isObjectCreationExpr()) {
            NodeList arguments = expressionToReplace.asObjectCreationExpr().getArguments();
            Expression labelArg = (Expression)arguments.get(0);
            Expression valueArg = (Expression)arguments.get(1);
            boolean valueEqualsToLabel = JavaRewriterUtil.equalsByNameAsString(labelArg, valueArg);
            Expression newExpression = JavaRewriterUtil.toExpression(value);
            boolean replace = labelArg.replace((Node)newExpression);
            if (!replace) {
                throw new IllegalArgumentException("Could not replace label expression");
            }
            if (valueEqualsToLabel && !(replace = valueArg.replace((Node)newExpression))) {
                throw new IllegalArgumentException("Could not replace value expression");
            }
        } else {
            Expression expression = JavaRewriterUtil.toExpression(value);
            boolean replace = expressionToReplace.replace((Node)expression);
            if (!replace) {
                throw new IllegalArgumentException("Could not replace expression");
            }
        }
        return new JavaDataProviderHandlerResult(this.sourceFile, this.javaRewriter.getResult());
    }

    private Expression findItemExpression(Expression searchExpression, Object item) {
        ArrayList argsToSearch = new ArrayList();
        if (searchExpression.isMethodCallExpr()) {
            argsToSearch = new ArrayList(searchExpression.asMethodCallExpr().getArguments());
        } else if (searchExpression.isObjectCreationExpr() && !(argsToSearch = new ArrayList(searchExpression.asObjectCreationExpr().getArguments())).isEmpty()) {
            argsToSearch.remove(0);
        }
        Optional<LabelValueDisabled> labelValueRecordOptional = this.getLabelValueRecord(item);
        if (labelValueRecordOptional.isPresent()) {
            LabelValueDisabled labelValueRecord = labelValueRecordOptional.get();
            ArrayList<ObjectCreationExpr> foundArgs = new ArrayList<ObjectCreationExpr>();
            List<ObjectCreationExpr> objectCreationExprs = argsToSearch.stream().filter(expression -> expression.isObjectCreationExpr() && !expression.asObjectCreationExpr().getArguments().isEmpty()).map(Expression::asObjectCreationExpr).toList();
            for (ObjectCreationExpr objectCreationExpr : objectCreationExprs) {
                Expression maybeLabelNode = (Expression)objectCreationExpr.getArguments().get(0);
                Expression maybeValueNode = (Expression)objectCreationExpr.getArguments().get(1);
                if (!maybeLabelNode.isStringLiteralExpr() || !JavaRewriterUtil.equalsByNameAsString(maybeLabelNode, (Expression)new StringLiteralExpr(labelValueRecord.label)) || !JavaRewriterUtil.equalsByNameAsString(maybeValueNode, (Expression)new StringLiteralExpr(labelValueRecord.value))) continue;
                foundArgs.add(objectCreationExpr);
            }
            if (foundArgs.size() > 1) {
                throw new IllegalArgumentException("More than one equal label-value pair is found");
            }
            if (foundArgs.size() == 1) {
                return (Expression)foundArgs.get(0);
            }
            return null;
        }
        Expression searchingExpression = JavaRewriterUtil.toExpression(item);
        for (Expression arg : argsToSearch) {
            if (!JavaRewriterUtil.typesEqual(arg.calculateResolvedType(), item.getClass()) || !JavaRewriterUtil.equalsByNameAsString(searchingExpression, arg)) continue;
            return arg;
        }
        return null;
    }

    private Optional<LabelValueDisabled> getLabelValueRecord(Object item) {
        Field[] declaredFields = item.getClass().getDeclaredFields();
        if (declaredFields.length != 3) {
            return Optional.empty();
        }
        if (this.hasField(item.getClass(), LABEL_KEY) && this.hasField(item.getClass(), VALUE_KEY) && this.hasField(item.getClass(), "enabled")) {
            String label = (String)this.getFieldValue(item, LABEL_KEY);
            String value = (String)this.getFieldValue(item, VALUE_KEY);
            boolean enabled = Boolean.TRUE.equals(this.getFieldValue(item, "enabled"));
            return Optional.of(new LabelValueDisabled(label, value, !enabled));
        }
        return Optional.empty();
    }

    private <T> T getFieldValue(Object object, String fieldName) {
        try {
            Field declaredField = object.getClass().getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return (T)declaredField.get(object);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private boolean hasField(Class<?> clazz, String fieldName) {
        try {
            clazz.getDeclaredField(fieldName);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private Object getItem(Component component) {
        try {
            Field item = component.getClass().getDeclaredField("item");
            item.setAccessible(true);
            return item.get(component);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not find item of the component", ex);
        }
    }

    public static void handleDataStatementsAndClearDataProps(CompilationUnit compilationUnit, VariableDeclarator parentVarDec, JavaComponent javaComponent, InsertionPoint insertionPoint, String dataEntityRecordName) {
        boolean hasSetItemsProps;
        List<JavaComponent> itemComponents = javaComponent.children().stream().filter(child -> FlowComponentQuirks.childrenGeneratesData(javaComponent, child)).toList();
        if (!itemComponents.isEmpty()) {
            if (javaComponent.tag().contains("Grid")) {
                JavaDataProviderHandler.addEntityDataStatements(compilationUnit, parentVarDec, JavaDataProviderHandler.childrenToLabelValueEnabledList(javaComponent), insertionPoint, javaComponent.getItemsFromProperty(), dataEntityRecordName);
            } else {
                JavaDataProviderHandler.addLabelValueDataStatements(compilationUnit, parentVarDec, JavaDataProviderHandler.childrenToLabelValueEnabledList(javaComponent), insertionPoint);
            }
            javaComponent.children().removeAll(itemComponents);
        }
        if (hasSetItemsProps = FlowComponentQuirks.hasSetItemsProps(javaComponent)) {
            if (javaComponent.tag().contains("Grid")) {
                JavaDataProviderHandler.addEntityDataStatements(compilationUnit, parentVarDec, JavaDataProviderHandler.propsToLabelValueDisabledList(javaComponent), insertionPoint, javaComponent.getItemsFromProperty(), dataEntityRecordName);
            } else {
                JavaDataProviderHandler.addLabelValueDataStatements(compilationUnit, parentVarDec, JavaDataProviderHandler.propsToLabelValueDisabledList(javaComponent), insertionPoint);
            }
        }
    }

    private static void addLabelValueDataStatements(CompilationUnit compilationUnit, VariableDeclarator parentVarDec, List<LabelValueDisabled> labelValueDisabledList, InsertionPoint insertionPoint) {
        LabelValuePairRecordRewriter javaClassOrRecordRewriter = new LabelValuePairRecordRewriter(compilationUnit);
        String recordName = javaClassOrRecordRewriter.addOrGetLabelValueEnabledRecordName();
        ClassOrInterfaceType recordType = new ClassOrInterfaceType();
        recordType.setName(recordName);
        JavaDataProviderHandler.updateVarDeclarationByAddingType(parentVarDec, recordType);
        boolean anyDisabled = false;
        MethodCallExpr setItemCallExpr = new MethodCallExpr((Expression)parentVarDec.getNameAsExpression(), "setItems");
        for (LabelValueDisabled labelValueDisabled : labelValueDisabledList) {
            anyDisabled = labelValueDisabled.disabled || anyDisabled;
            NodeList args = new NodeList();
            ObjectCreationExpr newItemExpr = new ObjectCreationExpr(null, recordType, args);
            args.add((Node)new StringLiteralExpr(labelValueDisabled.label));
            args.add((Node)new StringLiteralExpr(labelValueDisabled.value));
            if (Boolean.TRUE.equals(labelValueDisabled.disabled)) {
                args.add((Node)new BooleanLiteralExpr(false));
            }
            setItemCallExpr.addArgument((Expression)newItemExpr);
        }
        insertionPoint.add((Statement)new ExpressionStmt((Expression)setItemCallExpr));
        JavaDataProviderHandler.addSetItemLabelGeneratorStmt(parentVarDec, insertionPoint, recordType);
        if (anyDisabled) {
            JavaDataProviderHandler.addSetItemEnabledProviderMethodExpr(parentVarDec, insertionPoint, recordType);
        }
    }

    private static void addEntityDataStatements(CompilationUnit compilationUnit, VariableDeclarator parentVarDec, List<LabelValueDisabled> labelValueDisabledList, InsertionPoint insertionPoint, List<Map<String, Object>> items, String dataEntityRecordName) {
        DataEntityRecordRewriter dataEntityRecordRewriter = new DataEntityRecordRewriter(compilationUnit);
        String recordName = dataEntityRecordRewriter.addOrGetDataEntityRecordName(items.get(0), dataEntityRecordName);
        ClassOrInterfaceType recordType = new ClassOrInterfaceType();
        recordType.setName(recordName);
        JavaDataProviderHandler.updateVarDeclarationByAddingType(parentVarDec, recordType);
        MethodCallExpr setItemCallExpr = new MethodCallExpr((Expression)parentVarDec.getNameAsExpression(), "setItems");
        for (Map<String, Object> item : items) {
            NodeList args = new NodeList();
            ObjectCreationExpr newItemExpr = new ObjectCreationExpr(null, recordType, args);
            for (Map.Entry<String, Object> itemValues : item.entrySet()) {
                args.add((Node)new StringLiteralExpr(itemValues.getValue().toString()));
            }
            setItemCallExpr.addArgument((Expression)newItemExpr);
        }
        insertionPoint.add((Statement)new ExpressionStmt((Expression)setItemCallExpr));
    }

    private static void addSetItemLabelGeneratorStmt(VariableDeclarator variableDeclarator, InsertionPoint insertionPoint, ClassOrInterfaceType recordType) {
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)variableDeclarator.getNameAsExpression(), "setItemLabelGenerator");
        MethodReferenceExpr methodReferenceExpr = new MethodReferenceExpr();
        methodReferenceExpr.setScope((Expression)new NameExpr(recordType.getName()));
        methodReferenceExpr.setIdentifier(LABEL_KEY);
        methodCallExpr.addArgument((Expression)methodReferenceExpr);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)methodCallExpr));
    }

    private static void addSetItemEnabledProviderMethodExpr(VariableDeclarator variableDeclarator, InsertionPoint insertionPoint, ClassOrInterfaceType recordType) {
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)variableDeclarator.getNameAsExpression(), "setItemEnabledProvider");
        MethodReferenceExpr methodReferenceExpr = new MethodReferenceExpr();
        methodReferenceExpr.setScope((Expression)new NameExpr(recordType.getName()));
        methodReferenceExpr.setIdentifier("enabled");
        methodCallExpr.addArgument((Expression)methodReferenceExpr);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)methodCallExpr));
    }

    private static void updateVarDeclarationByAddingType(VariableDeclarator parentVarDec, ClassOrInterfaceType type) {
        Type type2 = parentVarDec.getType();
        if (type2 instanceof ClassOrInterfaceType) {
            ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)type2;
            classOrInterfaceType.setTypeArguments(new Type[]{type});
            Expression initializer = parentVarDec.getInitializer().orElse(null);
            if (initializer != null && initializer instanceof ObjectCreationExpr) {
                ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)initializer;
                ClassOrInterfaceType toDeleteType = new ClassOrInterfaceType();
                toDeleteType.setName("DELETE_THIS");
                objectCreationExpr.getType().setTypeArguments(new Type[]{toDeleteType});
            }
        } else {
            throw new IllegalArgumentException("Unknown variable " + String.valueOf(parentVarDec.getType()));
        }
    }

    private static List<LabelValueDisabled> childrenToLabelValueEnabledList(JavaComponent component) {
        List<JavaComponent> children = component.children();
        ArrayList<LabelValueDisabled> list = new ArrayList<LabelValueDisabled>();
        for (JavaComponent child : children) {
            String label = null;
            if (child.props().containsKey(LABEL_KEY)) {
                label = (String)child.props().get(LABEL_KEY);
            } else if (child.props().containsKey("text")) {
                label = (String)child.props().get("text");
            }
            String value = child.props().containsKey(VALUE_KEY) ? (String)child.props().get(VALUE_KEY) : label;
            if (label == null) {
                throw new IllegalArgumentException("Unknown property. Label cannot be null");
            }
            list.add(new LabelValueDisabled(label, value, child.props().containsKey(DISABLED_KEY)));
        }
        return list;
    }

    private static List<LabelValueDisabled> propsToLabelValueDisabledList(JavaComponent component) {
        ArrayList<LabelValueDisabled> list = new ArrayList<LabelValueDisabled>();
        if (component.props().containsKey("items")) {
            List items = (List)component.props().get("items");
            for (Map item : items) {
                String label = (String)item.get(LABEL_KEY);
                String value = (String)item.get(VALUE_KEY);
                Boolean disabled = (Boolean)item.get(DISABLED_KEY);
                list.add(new LabelValueDisabled(label, value, Boolean.TRUE.equals(disabled)));
            }
        }
        return list;
    }

    public record JavaDataProviderHandlerResult(File file, String result) {
    }

    private record LabelValueDisabled(String label, String value, boolean disabled) {
    }
}

