package com.vaadin.copilot.analytics;

import java.util.Map;

/**
 * Tracking request
 *
 * @param userId      user identifier, can be userKey or proKey
 * @param anonymousId identifier of anonymous user, can be machineId
 * @param event       Event name
 * @param properties  Event properties
 * @param context     Event context properties
 */
public record AnalyticsRequest(String userId, String anonymousId, String event, Map<String, String> properties,
                               Map<String, String> context) {
}
