package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.LoadRulesRequest;
import com.vaadin.copilot.plugins.themeeditor.messages.LoadRulesResponse;
import com.vaadin.copilot.plugins.themeeditor.utils.CssRule;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;

import java.util.List;

public class LoadRulesHandler implements MessageHandler {

    private final HasThemeModifier hasThemeModifier;

    public LoadRulesHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public BaseResponse handle(JsonObject data) {
        LoadRulesRequest request = JsonUtils.readToObject(data,
                LoadRulesRequest.class);
        List<CssRule> rules = hasThemeModifier.getThemeModifier()
                .getCssRules(request.getSelectors());
        return new LoadRulesResponse(rules);
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.LOAD_RULES.getValue();
    }
}
