package com.vaadin.copilot;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {

    private static final Pattern endsWithNumber = Pattern.compile("([0-9]+)$");

    /**
     * Takes a filename and increases a trailing number on the name (excluding the extension).
     *
     * <p>For example, "file1.txt" would return "file2.txt", "file.txt" would return "file1.txt" and "file123.txt" would
     * return "file124.txt". If the filename doesn't end with a number, a 1 is added at the end.
     *
     * @param filename the string to increase
     * @return the input string with the trailing number increased by one, or with a 1 added at the end if it didn't end
     *     with a number
     */
    public static String increaseTrailingNumber(String filename) {
        String[] parts = filename.split("\\.", 2);
        String base = parts[0];
        String extension = parts[1];

        Matcher matcher = endsWithNumber.matcher(base);
        if (matcher.find()) {
            return base.substring(0, matcher.start()) + (Integer.parseInt(matcher.group()) + 1) + "." + extension;
        }
        return base + "1." + extension;
    }

    /**
     * Finds the first folder inside the given folder that contains more than one sub-folder.
     *
     * <p>
     *
     * @param javaSourceFolder the root java source folder
     * @return the first folder that contains more than one sub-folder
     */
    public static File getSinglePackage(File javaSourceFolder) {
        File[] files = javaSourceFolder.listFiles();
        if (files == null || files.length == 0 || files.length > 1) {
            // Empty folder or folder containing multiple files
            return javaSourceFolder;
        }

        return getSinglePackage(files[0]);
    }
}
