package com.vaadin.copilot.communication;

import java.util.Map;

/**
 * StreamResponse is a record class used for sending responses to the client when the '/stream' endpoint is accessed.
 * These responses are sent as JSON objects and include a status, message, exception, and any modified file changes. The
 * status is represented by an enum, which helps determine and convey the response's status on the client side (see
 * {@link com.vaadin.copilot.communication.StreamResponseEnum}} for more details). More information about the endpoint
 * can be found in the {@link com.vaadin.copilot.communication.Router}. Additional details on the configuration for the
 * streaming endpoint are available in the {@link com.vaadin.copilot.communication.SecurityConfig} class.
 */
public record StreamResponse(
        StreamResponseEnum status, String message, String exception, Map<String, String> changes, int code) {}
