package com.vaadin.copilot.feedback;

import com.vaadin.copilot.CopilotServerClient;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

public class FeedbackClient extends CopilotServerClient {

    protected void sendFeedback(String userKey, String proKey, Map<String, String> data) {
        URI uri = getQueryURI("feedback");
        FeedbackRequest feedbackRequest = new FeedbackRequest(userKey, proKey, data);
        String json = writeAsJsonString(feedbackRequest);
        HttpRequest request = buildRequest(uri, json);
        getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }
}
