package com.vaadin.copilot.plugins.info;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.Json;
import elemental.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoHandler implements CopilotCommand {

    private final ApplicationConfiguration applicationConfiguration;

    public InfoHandler(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void handleConnect(DevToolsInterface devToolsInterface) {
        try {
            JsonObject json = Json.createObject();
            json.put("info", objectMapper.writeValueAsString(new CopilotInfo(applicationConfiguration)));
            devToolsInterface.send("copilot-info", json);
        } catch (JsonProcessingException e) {
            getLogger().error("Failed to send info message", e);
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        return false;
    }
}
