package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.OpenCssRequest;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.copilot.plugins.themeeditor.utils.ThemeEditorException;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import java.io.File;

public class OpenCssHandler implements MessageHandler {

    private final HasThemeModifier hasThemeModifier;

    public OpenCssHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public BaseResponse handle(JsonObject data) {
        OpenCssRequest request = JsonUtils.readToObject(data, OpenCssRequest.class);
        String selector = request.getSelector();
        int line = hasThemeModifier.getThemeModifier().getRuleLocationLine(selector);

        // rule not found, create empty for given selector
        if (line == -1) {
            hasThemeModifier.getThemeModifier().createEmptyStyleRule(selector);
            // wait for file to be flushed after writing empty rule, max 100ms
            long now = System.currentTimeMillis();
            do {
                line = hasThemeModifier.getThemeModifier().getRuleLocationLine(selector);
            } while (line == -1 && System.currentTimeMillis() - now < 100);

            if (line == -1) {
                throw new ThemeEditorException("Cannot create empty rule for " + selector);
            }
        }

        File stylesheet = hasThemeModifier.getThemeModifier().getStyleSheetFile();

        IdeUtils.openFile(stylesheet, line);

        return BaseResponse.ok();
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.OPEN_CSS.getValue();
    }
}
