package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.RulesRequest;
import com.vaadin.copilot.plugins.themeeditor.utils.CssRule;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class RulesHandler implements MessageHandler {

    private final HasThemeModifier hasThemeModifier;

    public RulesHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public BaseResponse handle(JsonObject data) {
        RulesRequest request = JsonUtils.readToObject(data, RulesRequest.class);

        // needs to be final for ExecuteAndUndo lambdas
        final List<CssRule> rules = new ArrayList<>(request.getRules());
        hasThemeModifier.getThemeModifier().setThemeProperties(rules);
        return BaseResponse.ok();
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.RULES.getValue();
    }
}
