/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.copilot.javarewriter.JavaBatchRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRewriteHandler
implements CopilotCommand {
    public static final String UNDO_LABEL = CopilotIDEPlugin.undoLabel("Java view update");
    public static final String ERROR_KEY = "error";
    private final ProjectManager projectManager;

    public JavaRewriteHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("set-component-property")) {
            String reqId = data.getString("reqId");
            JsonObject respData = Json.createObject();
            respData.put("reqId", reqId);
            try {
                this.handleSetComponentProperty(data);
            }
            catch (Exception e) {
                this.getLogger().error("Failed to set component property", (Throwable)e);
                respData.put(ERROR_KEY, "Failed to set component property. See the server log for more details");
            }
            devToolsInterface.send(command + "-response", respData);
            return true;
        }
        if (command.equals("add-call")) {
            String reqId = data.getString("reqId");
            JsonObject respData = Json.createObject();
            respData.put("reqId", reqId);
            try {
                this.handleAddCall(data);
            }
            catch (Exception e) {
                this.getLogger().error("Failed to add call", (Throwable)e);
                respData.put(ERROR_KEY, "Failed to add call. See the server log for more details");
            }
            devToolsInterface.send(command + "-response", respData);
            return true;
        }
        if (command.equals("delete-components")) {
            String reqId = data.getString("reqId");
            JsonObject respData = Json.createObject();
            respData.put("reqId", reqId);
            try {
                this.handleDeleteComponents(data.getArray("components"));
            }
            catch (Exception e) {
                this.getLogger().error("Failed to delete component", (Throwable)e);
                respData.put(ERROR_KEY, "Failed to delete component. See the server log for more details");
            }
            return true;
        }
        if (command.equals("add-template")) {
            String reqId = data.getString("reqId");
            JsonObject respData = Json.createObject();
            respData.put("reqId", reqId);
            try {
                this.handleAddTemplate(data);
            }
            catch (Exception e) {
                this.getLogger().error("Failed to add template", (Throwable)e);
                respData.put(ERROR_KEY, "Failed to add template. See the server log for more details");
            }
            devToolsInterface.send(command + "-response", respData);
            return true;
        }
        if (command.equals("drag-and-drop")) {
            String reqId = data.getString("reqId");
            JsonObject respData = Json.createObject();
            respData.put("reqId", reqId);
            try {
                this.handleDragAndDrop(data);
            }
            catch (Exception e) {
                this.getLogger().error("Unable to handle component drop", (Throwable)e);
                respData.put(ERROR_KEY, "Unable to handle component drop. See the server log for more details");
            }
            devToolsInterface.send(command + "-response", respData);
            return true;
        }
        if (command.equals("set-alignment")) {
            String reqId = data.getString("reqId");
            JsonObject respData = Json.createObject();
            respData.put("reqId", reqId);
            try {
                this.handleAlignment(data);
            }
            catch (Exception e) {
                this.getLogger().error("Unable to set alignment", (Throwable)e);
                respData.put(ERROR_KEY, "Unable to set alignment. See the server log for more details");
            }
            devToolsInterface.send(command + "-response", respData);
        }
        return false;
    }

    private void handleAddCall(JsonObject data) throws IOException {
        String func = data.getString("func");
        String parameter = data.getString("parameter");
        Integer lineToShowInIde = data.hasKey("lineToShowInIde") ? Integer.valueOf((int)data.getNumber("lineToShowInIde")) : null;
        JsonObject component = data.getObject("component");
        JavaRewriter.ComponentTypeAndSourceLocation typeAndSourceLocation = this.findComponentInfo(component);
        File javaFile = this.projectManager.getSourceFile(typeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        JavaRewriter.ComponentInfo info = rewriter.findComponentInfo(typeAndSourceLocation);
        if (!JavaRewriterUtil.hasSingleParameterMethod(info.type(), func)) {
            throw new IllegalArgumentException("Component does not support the given method");
        }
        rewriter.addCall(info, func, new JavaRewriter.Code(parameter));
        String result = rewriter.getResult();
        this.projectManager.writeFile(javaFile, UNDO_LABEL, result);
        if (lineToShowInIde != null) {
            int lineNumber = rewriter.getFirstModifiedRow() + lineToShowInIde;
            IdeUtils.openFile(javaFile, lineNumber);
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(1000L);
                    IdeUtils.openFile(javaFile, lineNumber);
                }
                catch (InterruptedException e) {
                    this.getLogger().error("Failed to show file in IDE", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    private void handleDeleteComponents(JsonArray componentsJson) {
        ArrayList<JavaRewriter.ComponentTypeAndSourceLocation> components = new ArrayList<JavaRewriter.ComponentTypeAndSourceLocation>();
        for (int i = 0; i < componentsJson.length(); ++i) {
            components.add(this.findComponentInfo(componentsJson.getObject(i)));
        }
        JavaBatchRewriter batchRewriter = new JavaBatchRewriter(this.projectManager, components);
        batchRewriter.deleteAll();
        batchRewriter.writeResult();
    }

    private void handleSetComponentProperty(JsonObject data) throws IOException {
        String property = data.getString("property");
        String value = data.getString("value");
        JsonObject component = data.getObject("component");
        JavaRewriter.ComponentTypeAndSourceLocation typeAndSourceLocation = this.findComponentInfo(component);
        File javaFile = this.projectManager.getSourceFile(typeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        JavaRewriter.ComponentInfo info = rewriter.findComponentInfo(typeAndSourceLocation);
        String setter = JavaRewriterUtil.getSetterName(property, info.type(), true);
        rewriter.replaceFunctionCall(info, setter, value);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleAddTemplate(JsonObject data) throws IOException {
        List<JavaRewriter.JavaComponent> template = JavaRewriter.JavaComponent.componentsFromJson(data.getArray("template"));
        JavaRewriter.Where where = JavaRewriter.Where.valueOf(data.getString("where").toUpperCase(Locale.ENGLISH));
        JavaRewriter.ComponentTypeAndSourceLocation refSource = this.findComponentInfo(data.getObject("refNode"));
        File javaFile = this.projectManager.getSourceFile(refSource.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        JavaRewriter.ComponentInfo ref = rewriter.findComponentInfo(refSource);
        if (where == JavaRewriter.Where.APPEND) {
            rewriter.addComponentUsingTemplate(null, ref, where, template);
        } else {
            if (!refSource.parent().javaFile().equals(refSource.javaFile())) {
                throw new IllegalArgumentException("Cannot insert before a component in one file (" + String.valueOf(refSource.javaFile()) + ") when the parent is in another file (" + String.valueOf(refSource.parent().javaFile()) + ")");
            }
            JavaRewriter.ComponentInfo parent = rewriter.findComponentInfo(refSource.parent());
            rewriter.addComponentUsingTemplate(ref, parent, where, template);
        }
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleDragAndDrop(JsonObject data) throws IOException {
        JavaRewriter.ComponentInfo insertBeforeRef;
        JavaRewriter.Where where = JavaRewriter.Where.valueOf(data.getString("where").toUpperCase(Locale.ENGLISH));
        JavaRewriter.ComponentTypeAndSourceLocation dragged = this.findComponentInfo(data.getObject("dragged"));
        JavaRewriter.ComponentTypeAndSourceLocation container = this.findComponentInfo(data.getObject("container"));
        JavaRewriter.ComponentTypeAndSourceLocation insertBefore = where == JavaRewriter.Where.BEFORE ? this.findComponentInfo(data.getObject("insertBefore")) : null;
        File javaFile = this.projectManager.getSourceFile(container.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        JavaRewriter.ComponentInfo draggedRef = rewriter.findComponentInfo(dragged);
        JavaRewriter.ComponentInfo containerRef = rewriter.findComponentInfo(container);
        JavaRewriter.ComponentInfo componentInfo = insertBeforeRef = insertBefore == null ? null : rewriter.findComponentInfo(insertBefore);
        if (!dragged.javaFile().equals(container.javaFile())) {
            throw new IllegalArgumentException("Cannot move a component in one file (" + String.valueOf(dragged.javaFile()) + ") to another file (" + String.valueOf(container.parent().javaFile()) + ")");
        }
        rewriter.moveComponent(draggedRef, containerRef, insertBeforeRef, where);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    private void handleAlignment(JsonObject data) throws IOException, IllegalAccessException {
        JavaRewriter.AlignmentMode mode = JavaRewriter.AlignmentMode.valueOf(data.getString("alignmentMode").replace('-', '_').toUpperCase(Locale.ENGLISH));
        JavaRewriter.ComponentTypeAndSourceLocation componentTypeAndSourceLocation = this.findComponentInfo(data.getObject("componentId"));
        JsonArray lumoClassesJson = data.getArray("lumoClasses");
        ArrayList<String> lumoClasses = new ArrayList<String>();
        for (int i = 0; i < lumoClassesJson.length(); ++i) {
            lumoClasses.add(lumoClassesJson.getString(i));
        }
        boolean selected = data.getBoolean("selected");
        File javaFile = this.projectManager.getSourceFile(componentTypeAndSourceLocation.createLocation());
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(javaFile));
        JavaRewriter.ComponentInfo componentInfo = rewriter.findComponentInfo(componentTypeAndSourceLocation);
        rewriter.setAlignment(componentInfo, mode, selected, lumoClasses);
        this.projectManager.writeFile(javaFile, UNDO_LABEL, rewriter.getResult());
    }

    public JavaRewriter.ComponentTypeAndSourceLocation findComponentInfo(JsonObject component) {
        VaadinSession session = VaadinSession.getCurrent();
        AtomicReference<Object> info = new AtomicReference<Object>(null);
        session.accessSynchronously((Command & Serializable)() -> {
            Element element = session.findElement((int)component.getNumber("uiId"), (int)component.getNumber("nodeId"));
            Optional c = element.getComponent();
            if (c.isPresent()) {
                Optional parent = ((Component)c.get()).getParent();
                JavaRewriter.ComponentTypeAndSourceLocation parentInfo = parent.map(p -> this.getSourceLocation((Component)p, null)).orElse(null);
                info.set(this.getSourceLocation((Component)c.get(), parentInfo));
            }
        });
        JavaRewriter.ComponentTypeAndSourceLocation res = info.get();
        if (res == null) {
            throw new IllegalArgumentException("Unable to find component in source");
        }
        return res;
    }

    private JavaRewriter.ComponentTypeAndSourceLocation getSourceLocation(Component component, JavaRewriter.ComponentTypeAndSourceLocation parentInfo) {
        ComponentTracker.Location createLocation = ComponentTracker.findCreate((Component)component);
        ComponentTracker.Location attachLocation = ComponentTracker.findAttach((Component)component);
        File javaFile = this.projectManager.getSourceFile(createLocation);
        return new JavaRewriter.ComponentTypeAndSourceLocation(component.getClass(), javaFile, createLocation, attachLocation, parentInfo);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

