package com.vaadin.copilot.ai;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.Copilot;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.communication.CopilotServerResponseCode;
import elemental.json.Json;
import elemental.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class AICommunicationUtil {

    public static void promptTextCannotCall(JsonObject data,
            DevToolsInterface devToolsInterface) {
        getLogger().error("Cannot call AI without ProKey");
        JsonObject responseData = Json.createObject();
        if (data.hasKey(CopilotCommand.KEY_REQ_ID)) {
            responseData.put(CopilotCommand.KEY_REQ_ID,
                    data.getString(CopilotCommand.KEY_REQ_ID));
        }
        responseData.put("code",
                CopilotServerResponseCode.COPILOT_AUTHORISATION_FAILED
                        .getCode());
        devToolsInterface.send(
                Copilot.PREFIX + AIConstants.MESSAGE_PROMPT_FAILED,
                responseData);
    }

    public static Map<String, String> getHillaSourceFiles(JsonObject data) {
        Map<String, String> sources = new HashMap<>();

        // Hilla source files;
        JsonObject reactSources = data.getObject("sources");
        if (reactSources != null) {
            for (String filename : reactSources.keys()) {
                getLogger().debug("Hilla file: {}", filename);
                sources.put(filename, reactSources.getString(filename));
            }
        }
        return sources;
    }

    public static void handlingExceptionsAndNotifyDevtoolsInterface(
            JsonObject dataJson, DevToolsInterface devToolsInterface,
            Throwable e) {
        JsonObject responseData = Json.createObject();
        if (dataJson.hasKey(CopilotCommand.KEY_REQ_ID)) {
            responseData.put(CopilotCommand.KEY_REQ_ID,
                    dataJson.getString(CopilotCommand.KEY_REQ_ID));
        }
        if (e.getCause() instanceof TimeoutException) {
            responseData.put("code", AIConstants.COPILOT_CLIENT_TIMEOUT_ERROR);
        } else {
            responseData.put("code", AIConstants.COPILOT_INTERNAL_ERROR);
        }
        responseData.put("message", "Error querying copilot server");
        getLogger().error("Error querying copilot server", e);
        devToolsInterface.send(
                Copilot.PREFIX + AIConstants.MESSAGE_PROMPT_FAILED,
                responseData);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AICommunicationUtil.class);
    }
}
