package com.vaadin.copilot.feedback;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;
import elemental.json.JsonObject;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FeedbackHandler implements CopilotCommand {

    private final String[] expectedData = { "type", "email", "description" };

    private final FeedbackClient client;

    public FeedbackHandler() {
        this.client = new FeedbackClient();
    }

    @Override
    public boolean handleMessage(String command, JsonObject data,
            DevToolsInterface devToolsInterface) {

        if (command.equals("feedback")) {
            Map<String, String> map = new HashMap<>();
            for (String key : expectedData) {
                map.put(key, data.getString(key));
            }
            String userKey = ProjectHelpers.getUserKey();
            String proKey = Optional.ofNullable(LocalProKey.get())
                    .map(ProKey::toJson).orElse(null);
            client.sendFeedback(userKey, proKey, map);
            return true;
        }

        return false;
    }

}
