package com.vaadin.copilot.ide;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.plugins.themeeditor.ThemeModifier;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import elemental.json.JsonValue;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class IdePluginCommandHandler implements CopilotCommand {

    private final ProjectManager projectManager;

    private final CopilotIDEPlugin plugin;

    public IdePluginCommandHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.plugin = CopilotIDEPlugin.getInstance();
    }

    @Override
    public boolean handleMessage(String command, JsonObject data,
            DevToolsInterface devToolsInterface) {
        try {
            if (command.equals("plugin-undo")) {
                if (plugin.isActive()) {
                    List<String> files = JsonUtils
                            .stream(data.getArray("files"))
                            .map(JsonValue::asString).map(this::filter)
                            .toList();
                    plugin.undo(files);
                }
                return true;
            }

            if (command.equals("plugin-redo")) {
                if (plugin.isActive()) {
                    List<String> files = JsonUtils
                            .stream(data.getArray("files"))
                            .map(JsonValue::asString).map(this::filter)
                            .toList();
                    plugin.redo(files);
                }
                return true;
            }

            if (command.equals("plugin-refresh")) {
                if (plugin.isActive()) {
                    plugin.refresh();
                }
            }

        } catch (IOException e) {
            throw new UnsupportedOperationException(
                    "Copilot Plugin operation failed", e);
        }
        return false;
    }

    private String filter(String filename) {
        if (filename.equals("$THEME_EDITOR_CSS")) {
            Optional<File> themeFolder = projectManager.getThemeFolder();
            if (themeFolder.isPresent()) {
                return themeFolder.get().toPath()
                        .resolve(ThemeModifier.THEME_EDITOR_CSS).toString();
            }
        }
        return filename;
    }

}
