/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.ai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.ServerInfo;
import com.vaadin.copilot.Copilot;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ai.AICommunicationUtil;
import com.vaadin.copilot.ai.AIConstants;
import com.vaadin.copilot.communication.CopilotServerRequest;
import com.vaadin.copilot.communication.CopilotServerResponse;
import com.vaadin.copilot.communication.CopilotServerResponseCode;
import com.vaadin.copilot.communication.StreamResponse;
import com.vaadin.copilot.communication.StreamResponseEnum;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import io.netty.handler.codec.http.HttpMethod;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;

public class AICommandHandler
extends CopilotServerClient
implements CopilotCommand {
    private final Map<String, String> serverInfoVersions;
    private final ProjectManager projectManager;
    private Map<String, Disposable> disposables = new HashMap<String, Disposable>();

    public AICommandHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
        ServerInfo serverInfo = new ServerInfo();
        this.serverInfoVersions = serverInfo.getVersions().stream().collect(Collectors.toMap(ServerInfo.NameAndVersion::name, ServerInfo.NameAndVersion::version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("prompt-text")) {
            HashMap<String, String> metadata = new HashMap<String, String>(this.serverInfoVersions);
            ProKey proKey = this.getProKey();
            String machineId = this.getMachineId();
            if (proKey == null && machineId == null) {
                AICommunicationUtil.promptTextCannotCall(data, devToolsInterface);
                return false;
            }
            if (proKey != null) {
                metadata.put("proKey", proKey.toJson());
            }
            if (machineId != null) {
                metadata.put("machineId", machineId);
            }
            String prompt = data.getString("text");
            Map<String, String> sources = AICommunicationUtil.getHillaSourceFiles(data);
            if (data.hasKey("uiid")) {
                Map<String, String> fileSourceMapJava;
                Double uiId = data.getNumber("uiid");
                VaadinSession session = VaadinSession.getCurrent();
                try {
                    session.lock();
                    fileSourceMapJava = this.getJavaSourceMap(uiId, session);
                }
                catch (IOException e) {
                    this.getLogger().error("Error reading requested project Flow Java files", (Throwable)e);
                    devToolsInterface.send("copilot-prompt-failed", Json.createObject());
                    boolean bl = true;
                    return bl;
                }
                finally {
                    session.unlock();
                }
                sources.putAll(fileSourceMapJava);
            }
            HashMap<String, String> relativeSources = new HashMap<String, String>();
            for (String filename : sources.keySet()) {
                try {
                    relativeSources.put(this.projectManager.makeRelative(filename), sources.get(filename));
                }
                catch (IOException e) {
                    JsonObject responseData = Json.createObject();
                    if (data.hasKey("reqId")) {
                        responseData.put("reqId", data.getString("reqId"));
                    }
                    responseData.put("code", -300.0);
                    responseData.put("message", "Error processing the files");
                    this.getLogger().error("Error making file relative to project", (Throwable)e);
                    devToolsInterface.send("copilot-prompt-failed", responseData);
                    return true;
                }
            }
            try {
                CopilotServerRequest req = new CopilotServerRequest(prompt, relativeSources, metadata);
                JsonObject responseData = Json.createObject();
                responseData.put("requestId", data.hasKey("reqId") ? data.getString("reqId") : "");
                this.getLogger().debug("Request Registered in client: " + responseData.getString("requestId"));
                devToolsInterface.send("copilot-prompt-requestId", responseData);
                this.queryCopilotServer(req, devToolsInterface, data);
            }
            catch (Exception e) {
                AICommunicationUtil.handlingExceptionsAndNotifyDevtoolsInterface(data, devToolsInterface, e);
                return true;
            }
            return true;
        }
        if (command.equals("prompt-cancel")) {
            JsonObject responseData = Json.createObject();
            if (!data.hasKey("requestId") || !data.hasKey("reqId")) {
                this.getLogger().error("Impossible to cancel without request and cancel request Ids");
                return false;
            }
            responseData.put("reqId", data.getString("reqId"));
            responseData.put("requestId", data.getString("requestId"));
            this.getLogger().debug("Trying to cancel Disposable object with id: {} - object: {}", (Object)data.getString("reqId"), (Object)this.disposables.get(data.getString("reqId")));
            if (this.disposables.get(data.getString("requestId")) != null) {
                responseData.put("message", "Request cancelled successfully");
                Disposable disposable = this.disposables.get(data.getString("requestId"));
                disposable.dispose();
                this.disposables.remove(data.getString("requestId"));
                disposable = null;
                devToolsInterface.send("copilot-prompt-cancel-ok", responseData);
            } else {
                responseData.put("message", "Error cancelling the request with id: " + data.getString("reqId"));
                devToolsInterface.send("copilot-prompt-cancel-failed", responseData);
            }
            return true;
        }
        return false;
    }

    private Map<String, String> getJavaSourceMap(Number uiId, VaadinSession session) throws IOException {
        UI ui = session.getUIById(uiId.intValue());
        ArrayList<Component> componentList = new ArrayList<Component>();
        HashMap<String, String> sources = new HashMap<String, String>();
        this.addComponents((Component)ui, componentList);
        HashSet<ComponentTracker.Location> locations = new HashSet<ComponentTracker.Location>();
        for (Component component : componentList) {
            ComponentTracker.Location create = ComponentTracker.findCreate((Component)component);
            ComponentTracker.Location attach = ComponentTracker.findAttach((Component)component);
            if (create == null || attach == null) continue;
            locations.add(create);
            locations.add(attach);
        }
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)session.getService().getContext());
        for (ComponentTracker.Location location : locations) {
            File javaFile = location.findJavaFile((AbstractConfiguration)applicationConfiguration);
            if (sources.containsKey(location.filename())) continue;
            ArrayList<String> javaFileNames = new ArrayList<String>();
            if (javaFile.exists()) {
                javaFileNames.add(javaFile.getName());
                sources.put(javaFile.getAbsolutePath(), this.projectManager.readFile(javaFile.getPath()));
            }
            this.getLogger().debug("Java filenames: {}", javaFileNames);
        }
        return sources;
    }

    private void addComponents(Component component, List<Component> componentList) {
        componentList.add(component);
        component.getChildren().forEach(c -> this.addComponents((Component)c, componentList));
    }

    private void queryCopilotServer(CopilotServerRequest req, DevToolsInterface devToolsInterface, JsonObject dataJson) {
        URI queryUriStream = this.getQueryURI("stream");
        String json = this.writeAsJsonString(req);
        if (Copilot.isDevelopmentMode()) {
            this.getLogger().debug("Querying copilot server at {} using {}", (Object)queryUriStream, (Object)json);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        AtomicReference<StringBuilder> jsonBuffer = new AtomicReference<StringBuilder>(new StringBuilder());
        AtomicBoolean completedSuccessfully = new AtomicBoolean(false);
        Disposable disposable = ((HttpClient.ResponseReceiver)HttpClient.create().responseTimeout(Duration.of(140L, ChronoUnit.SECONDS)).headers(headers -> headers.set("Content-Type", (Object)"application/json")).request(HttpMethod.POST).send((Publisher)ByteBufMono.fromString((Publisher)Mono.just((Object)json))).uri(queryUriStream)).responseContent().asString().doOnError(e -> AICommunicationUtil.handlingExceptionsAndNotifyDevtoolsInterface(dataJson, devToolsInterface, e)).subscribe(data -> {
            String newData = data.trim();
            if (newData.startsWith("data:")) {
                newData = newData.substring(5);
            }
            ((StringBuilder)jsonBuffer.get()).append(newData);
            String accumulatedData = ((StringBuilder)jsonBuffer.get()).toString();
            try {
                Optional<StreamResponse> parsedStreamResponseOpt = this.tryParseJson(objectMapper, accumulatedData);
                if (parsedStreamResponseOpt.isPresent()) {
                    StreamResponse parsedStreamResponse = parsedStreamResponseOpt.get();
                    JsonObject responseData = Json.createObject();
                    responseData.put("status", parsedStreamResponse.status().getMessage());
                    this.getLogger().debug("Parsed JSON: " + String.valueOf(parsedStreamResponse));
                    devToolsInterface.send("copilot-prompt-status", responseData);
                    completedSuccessfully.set(true);
                    if (dataJson.hasKey("reqId")) {
                        responseData.put("reqId", dataJson.getString("reqId"));
                    }
                    if (parsedStreamResponse.code() < 0) {
                        responseData.put("code", (double)parsedStreamResponse.code());
                        responseData.put("message", parsedStreamResponse.message());
                        devToolsInterface.send("copilot-prompt-failed", responseData);
                    } else if (parsedStreamResponse.status() == StreamResponseEnum.POST_PROCESS) {
                        responseData.put("message", parsedStreamResponse.message());
                        responseData.put("changes", (JsonValue)parsedStreamResponse.changes().keySet().stream().map(Json::create).collect(JsonUtils.asArray()));
                        this.getLogger().debug("PostProcess finished");
                        devToolsInterface.send("copilot-prompt-ok", responseData);
                        CopilotServerResponse response = new CopilotServerResponse(CopilotServerResponseCode.HILLA_REACT.getCode(), parsedStreamResponse.status().getMessage(), parsedStreamResponse.changes());
                        this.handleQueryResponse(response);
                    }
                    jsonBuffer.set(new StringBuilder());
                }
            }
            catch (Exception e) {
                this.getLogger().error("Error parsing JSON: " + e.getMessage() + " - Accumulated data: " + accumulatedData);
                JsonObject responseData = Json.createObject();
                responseData.put("reqId", dataJson.getString("reqId"));
                devToolsInterface.send("copilot-prompt-failed", responseData);
                jsonBuffer.set(new StringBuilder(accumulatedData));
            }
        }, error -> this.getLogger().error("Error: " + String.valueOf(error)), () -> {
            if (!completedSuccessfully.get()) {
                JsonObject responseData = Json.createObject();
                responseData.put("reqId", dataJson.getString("reqId"));
                this.getLogger().error("Stream did not completed successfully.");
                devToolsInterface.send("copilot-prompt-failed", responseData);
            } else {
                this.disposables.remove(dataJson.getString("reqId"));
                this.getLogger().debug("Stream completed successfully.");
            }
        });
        this.disposables.put(dataJson.getString("reqId"), disposable);
        this.getLogger().debug("Disposable object created for prompt {} - object: {} - RequestId: {}", new Object[]{json, disposable, dataJson.getString("reqId")});
    }

    private Optional<StreamResponse> tryParseJson(ObjectMapper objectMapper, String data) {
        try {
            return Optional.ofNullable((StreamResponse)objectMapper.readValue(data, StreamResponse.class));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private void handleQueryResponse(CopilotServerResponse response) throws IOException {
        if (response.code() == CopilotServerResponseCode.ERROR.getCode()) {
            this.getLogger().error("Copilot server returned error because an internal error. The reason could be a malformed request or a timeout.");
            return;
        }
        if (response.code() == CopilotServerResponseCode.ERROR_REQUEST.getCode()) {
            this.getLogger().error("Copilot server returned error because an internal error. The reason could be a malformed request or a timeout.");
            return;
        }
        if (response.code() == CopilotServerResponseCode.NOTHING.getCode()) {
            this.getLogger().debug("Copilot server returned no changes");
            return;
        }
        if (response.code() == CopilotServerResponseCode.HILLA_REACT.getCode()) {
            this.getLogger().debug("Copilot server returned Hilla/React changes");
        } else if (response.code() == CopilotServerResponseCode.FLOW.getCode()) {
            this.getLogger().debug("Copilot server returned Flow changes");
        } else if (response.code() == CopilotServerResponseCode.LOCAL.getCode()) {
            this.getLogger().debug("Copilot server returned Local changes");
        } else {
            if (response.code() < 0) {
                this.getLogger().debug("Copilot server returned Internal error code: {}", (Object)response.code());
                return;
            }
            this.getLogger().debug("Copilot server returned unknown response code: {}", (Object)response.code());
            return;
        }
        for (Map.Entry<String, String> change : response.changes().entrySet()) {
            try {
                this.projectManager.writeFile(this.projectManager.makeAbsolute(change.getKey()), AIConstants.COPILOT_AI_FILE_UPDATE_UNDO_LABEL, change.getValue());
            }
            catch (IOException e) {
                throw new IOException("Unable to write file (" + change.getKey() + ") with data from copilot server response", e);
            }
        }
    }

    ProKey getProKey() {
        return LocalProKey.get();
    }

    String getMachineId() {
        return MachineId.get();
    }

    public Map<String, Disposable> getDisposables() {
        return this.disposables;
    }
}

