package com.vaadin.copilot.analytics;

import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.copilot.CopilotServerClient;
import com.vaadin.copilot.CopilotVersion;
import com.vaadin.copilot.userinfo.UserInfo;
import com.vaadin.copilot.userinfo.UserInfoServerClient;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;

/** Client for tracking features of Copilot */
public class AnalyticsClient extends CopilotServerClient {

    private final String userKey;

    private final String machineId;

    private final boolean vaadiner;

    /** Constructor loading ProKey */
    public AnalyticsClient() {
        this.userKey = ProjectHelpers.getUserKey();
        this.machineId = MachineId.get();
        ProKey proKey = LocalProKey.get();
        if (proKey != null) {
            UserInfo userInfo = new UserInfoServerClient().getUserInfo(proKey.getProKey());
            this.vaadiner = userInfo != null && userInfo.vaadiner();
        } else {
            this.vaadiner = false;
        }
    }

    /**
     * Track event to copilot-server
     *
     * @param event
     *            Event name
     * @param properties
     *            Map of event properties
     */
    public void track(String event, Map<String, String> properties, Map<String, String> context) {
        properties = properties == null ? new HashMap<>() : new HashMap<>(properties);
        properties.put("Vaadiner", String.valueOf(vaadiner));
        properties.put("Version", CopilotVersion.getVersion());
        sendRequest(event, properties, context);
    }

    protected void sendRequest(String event, Map<String, String> properties, Map<String, String> context) {
        URI uri = getQueryURI("analytics");
        AnalyticsRequest trackingRequest = new AnalyticsRequest(userKey, machineId, event, properties, context);
        String json = writeAsJsonString(trackingRequest);
        HttpRequest request = buildRequest(uri, json);
        getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }
}
