package com.vaadin.copilot;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.stats.ProjectHelpers;

import elemental.json.Json;
import elemental.json.JsonObject;

import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineConfigurationHandler implements CopilotCommand {
    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-machine-configuration")) {
            JsonObject response = Json.createObject();
            try {
                File confFile = getConfFile();
                if (confFile.exists()) {
                    String json = FileUtils.readFileToString(confFile, StandardCharsets.UTF_8);
                    getLogger().debug("Reading configuration: {}", json);
                    response.put("conf", Json.parse(json));
                } else {
                    response.put("conf", Json.parse("{}"));
                }
            } catch (IOException e) {
                getLogger().error("Failed to read machine configuration", e);
                response.put("error", true);
            }
            devToolsInterface.send("copilot-machine-configuration", response);
            return true;
        } else if (command.equals("set-machine-configuration")) {
            try {
                String json = data.getString("conf");
                FileUtils.write(getConfFile(), json + "\n", StandardCharsets.UTF_8);
                getLogger().debug("Writing configuration: {}", json);
            } catch (IOException e) {
                getLogger().error("Failed to write machine configuration", e);
            }
            return true;
        }
        return false;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(MachineConfigurationHandler.class);
    }

    private File getConfFile() {
        return new File(ProjectHelpers.resolveVaadinHomeDirectory(), "copilot-configuration.json");
    }
}
