package com.vaadin.copilot.analytics;

import java.util.HashMap;
import java.util.Map;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.Copilot;
import com.vaadin.copilot.CopilotCommand;

import elemental.json.JsonObject;

public class AnalyticsInterceptor implements CopilotCommand {

    static final String CONTEXT = "context";

    private final AnalyticsClient analyticsClient;

    public AnalyticsInterceptor(AnalyticsClient analyticsClient) {
        this.analyticsClient = analyticsClient;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        Map<String, String> context = toMap(data.getObject(CONTEXT));
        // remove context from data not to cause unmarshalling issues
        data.remove(CONTEXT);
        if (command.equals("track-event")) {
            if (analyticsClient != null) {
                String event = Copilot.PREFIX + data.getString("event");
                JsonObject properties = data.getObject("properties");
                analyticsClient.track(event, toMap(properties), context);
            }
            return true;
        }
        return false;
    }

    private Map<String, String> toMap(JsonObject data) {
        if (data == null) {
            return null;
        }
        Map<String, String> map = new HashMap<>();
        for (String key : data.keys()) {
            map.put(key, data.get(key).asString());
        }
        return map;
    }

}
