package com.vaadin.copilot.ide;

import static com.vaadin.copilot.Copilot.PREFIX;

import java.util.Optional;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.flow.internal.JsonUtils;

import elemental.json.Json;
import elemental.json.JsonObject;

public class IdeHandler implements CopilotCommand {
    private final CopilotIDEPlugin idePlugin;
    private boolean idePluginActive;
    private final Optional<IdeUtils.IDE> ide;

    public IdeHandler(CopilotIDEPlugin idePlugin) {
        this.idePlugin = idePlugin;
        this.ide = IdeUtils.findIde();
    }

    @Override
    public void handleConnect(DevToolsInterface devToolsInterface) {
        idePluginActive = idePlugin.isActive();
        sendIdePluginState(devToolsInterface);
    }

    private void sendIdePluginState(DevToolsInterface devToolsInterface) {
        JsonObject jsonObject = Json.createObject();
        if (idePlugin.isActive()) {
            CopilotIDEPluginProperties props = idePlugin.getProperties();
            jsonObject.put("active", true);
            jsonObject.put("version", props.getVersion());
            jsonObject.put("supportedActions", JsonUtils.listToJson(props.getSupportedActions()));
            jsonObject.put("ide", props.getIde());
        } else {
            jsonObject.put("active", false);
            ide.ifPresent(value -> jsonObject.put("ide", value.getPluginIde()));
        }
        devToolsInterface.send(PREFIX + "plugin-state", jsonObject);
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        // User enabled plugin during work
        if (!idePluginActive && idePlugin.isActive()) {
            idePluginActive = true;
            sendIdePluginState(devToolsInterface);
        }

        // User disabled plugin during work
        if (idePluginActive && !idePlugin.isActive()) {
            idePluginActive = false;
            sendIdePluginState(devToolsInterface);
        }

        return false;
    }
}
