package com.vaadin.copilot;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

import com.vaadin.flow.server.frontend.ProxyFactory;
import com.vaadin.flow.server.frontend.installer.DefaultFileDownloader;
import com.vaadin.flow.server.frontend.installer.DownloadException;
import com.vaadin.flow.server.frontend.installer.FileDownloader;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;

public class Downloader {

    private Downloader() {
        // Util class
    }

    /**
     * Downloads a file from the given URL to the target file.
     *
     * @param url
     *            the URL to download from
     * @param target
     *            the target file to download to
     * @param projectManager
     *            the project manager to use to detect proxy configuration
     * @param progressListener
     *            the progress listener to use for tracking the download progress
     */
    public static void downloadFile(URL url, File target, ProjectManager projectManager,
            FileDownloader.ProgressListener progressListener) throws URISyntaxException, DownloadException {
        ProxyConfig proxyConfig = new ProxyConfig(ProxyFactory.getProxies(projectManager.getProjectRoot()));
        DefaultFileDownloader downloader = new DefaultFileDownloader(proxyConfig);
        downloader.download(url.toURI(), target, null, null, progressListener);
    }
}
