/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.ComponentSourceFinder;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.server.VaadinSession;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class FlowUtil {
    private FlowUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<ComponentTracker.Location, File> findActiveJavaFiles(ProjectManager projectManager, int uiId) {
        VaadinSession session = projectManager.getVaadinSession();
        try {
            session.lock();
            UI ui = session.getUIById(uiId);
            Map<Component, ComponentTypeAndSourceLocation> allComponents = FlowUtil.findAllComponentSourceLocations(projectManager, ui);
            HashSet<String> processedClasses = new HashSet<String>();
            LinkedHashMap<ComponentTracker.Location, File> locations = new LinkedHashMap<ComponentTracker.Location, File>();
            for (ComponentTypeAndSourceLocation componentTypeAndSourceLocation : allComponents.values()) {
                for (ComponentTracker.Location location : FlowUtil.getLocations(componentTypeAndSourceLocation)) {
                    File javaFile;
                    if (processedClasses.contains(location.className()) || !(javaFile = projectManager.getFileForClass(location.className())).exists()) continue;
                    processedClasses.add(location.className());
                    locations.put(location, javaFile);
                }
            }
            LinkedHashMap<ComponentTracker.Location, File> linkedHashMap = locations;
            return linkedHashMap;
        }
        finally {
            session.unlock();
        }
    }

    private static List<ComponentTracker.Location> getLocations(ComponentTypeAndSourceLocation componentTypeAndSourceLocation) {
        return Stream.concat(componentTypeAndSourceLocation.createLocationInProject().stream(), componentTypeAndSourceLocation.attachLocationInProject().stream()).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Component, ComponentTypeAndSourceLocation> findAllComponents(ProjectManager projectManager, int uiId) {
        VaadinSession session = projectManager.getVaadinSession();
        try {
            session.lock();
            UI ui = session.getUIById(uiId);
            Map<Component, ComponentTypeAndSourceLocation> map = FlowUtil.findAllComponentSourceLocations(projectManager, ui);
            return map;
        }
        finally {
            session.unlock();
        }
    }

    private static Map<Component, ComponentTypeAndSourceLocation> findAllComponentSourceLocations(ProjectManager projectManager, UI ui) {
        ArrayList<Component> componentList = new ArrayList<Component>();
        FlowUtil.addComponents((Component)ui, componentList);
        HashMap<Component, ComponentTypeAndSourceLocation> locations = new HashMap<Component, ComponentTypeAndSourceLocation>();
        ComponentSourceFinder sourceFinder = new ComponentSourceFinder(projectManager);
        for (Component component : componentList) {
            ComponentTypeAndSourceLocation typeAndSourceLocation = sourceFinder.findTypeAndSourceLocation(component, false);
            locations.put(component, typeAndSourceLocation);
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<? extends HasElement>> getViewChain(VaadinSession session, int uiId) {
        try {
            session.lock();
            UI ui = session.getUIById(uiId);
            if (ui == null) {
                List<Class<? extends HasElement>> list = Collections.emptyList();
                return list;
            }
            List<Class<? extends HasElement>> list = ui.getActiveRouterTargetsChain().stream().map(Object::getClass).toList();
            return list;
        }
        finally {
            session.unlock();
        }
    }

    private static void addComponents(Component component, List<Component> componentList) {
        componentList.add(component);
        component.getChildren().forEach(c -> FlowUtil.addComponents(c, componentList));
    }

    public static Integer getNodeId(Component component) {
        return component.getElement().getNode().getId();
    }
}

