/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.HotswapAgentDownloader;
import com.vaadin.copilot.JetbrainsRuntimeUtil;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.VsCodeUtil;
import com.vaadin.flow.server.VaadinServletContext;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.util.Optional;
import java.util.function.Consumer;

public class HotswapDownloadHandler
implements CopilotCommand {
    private final ProjectManager projectManager;
    static final String PROGRESS_PREFIX = "Progress: ";

    public HotswapDownloadHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("set-up-vs-code-hotswap")) {
            JsonObject returnData = Json.createObject();
            returnData.put("reqId", data.getString("reqId"));
            try {
                Consumer<String> statusUpdater = msg -> {
                    JsonObject json = Json.createObject();
                    if (msg.startsWith(PROGRESS_PREFIX)) {
                        json.put("progress", Double.parseDouble(msg.substring(PROGRESS_PREFIX.length())));
                    } else {
                        json.put("message", msg);
                    }
                    devToolsInterface.send("set-up-vs-code-hotswap-status", json);
                };
                JetbrainsRuntimeUtil jetbrainsRuntimeUtil = new JetbrainsRuntimeUtil(this.projectManager);
                Optional<File> jbrArchive = jetbrainsRuntimeUtil.downloadLatestJBR(statusUpdater);
                if (jbrArchive.isEmpty()) {
                    String error = "\"No JetBrains Runtime found for your architecture (%key%).\nVisit https://github.com/JetBrains/JetBrainsRuntime/releases to find a suitable one.\n\nPlease report this in %tracker% if you think Copilot should be able to figure it out.\"\n".replace("%key%", jetbrainsRuntimeUtil.getDownloadKey()).replace("%tracker%", "https://github.com/vaadin/copilot/issues");
                    ErrorHandler.setError(returnData, error);
                    devToolsInterface.send(command + "-response", returnData);
                    return true;
                }
                File jdkFolder = jetbrainsRuntimeUtil.unpackJbr(jbrArchive.get(), statusUpdater);
                File hotswapAgentJarLocation = jetbrainsRuntimeUtil.getHotswapAgentLocation(jdkFolder);
                new HotswapAgentDownloader(this.projectManager).downloadHotswapAgent(hotswapAgentJarLocation, statusUpdater);
                statusUpdater.accept("Creating VS Code launch configuration");
                VsCodeUtil.ensureAutoHotDeploy(this.projectManager.getProjectRoot());
                VsCodeUtil.addHotswapAgentLaunchConfiguration(this.projectManager.getProjectRoot(), jetbrainsRuntimeUtil.getJavaExecutable(jdkFolder), (VaadinServletContext)this.projectManager.getVaadinSession().getService().getContext());
                devToolsInterface.send(command + "-response", returnData);
            }
            catch (Exception e) {
                ErrorHandler.sendErrorResponse(devToolsInterface, command, returnData, "Error downloading JetBrains Runtime", e);
            }
            return true;
        }
        return false;
    }
}

