/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.AccessRequirement;
import com.vaadin.copilot.AccessRequirementUtil;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.JavaReflectionUtil;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.SpringBridge;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.VaadinServletContext;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiServiceHandler
implements CopilotCommand {
    private final ProjectManager projectManager;
    private final VaadinServletContext context;

    public UiServiceHandler(ProjectManager projectManager, VaadinServletContext context) {
        this.projectManager = projectManager;
        this.context = context;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-browser-callables")) {
            JsonObject returnData = Json.createObject();
            returnData.put("reqId", data.getString("reqId"));
            List<Object> browserCallables = EndpointRequestUtil.isHillaAvailable() ? SpringBridge.getEndpoints(this.context) : new ArrayList();
            JsonArray browserCallableJson = (JsonArray)browserCallables.stream().sorted(UiServiceHandler::sortByClassAndMethodName).map(serviceMethod -> this.serviceMethodToJson((SpringBridge.ServiceMethodInfo)serviceMethod, true)).collect(JsonUtils.asArray());
            returnData.put("browserCallables", (JsonValue)browserCallableJson);
            List<SpringBridge.ServiceMethodInfo> flowUIServices = SpringBridge.getFlowUIServices(this.context);
            JsonArray flowUiServicesJson = (JsonArray)flowUIServices.stream().sorted(UiServiceHandler::sortByClassAndMethodName).map(serviceMethod -> this.serviceMethodToJson((SpringBridge.ServiceMethodInfo)serviceMethod, false)).collect(JsonUtils.asArray());
            returnData.put("flowServices", (JsonValue)flowUiServicesJson);
            devToolsInterface.send("resp" + command, returnData);
            return true;
        }
        return false;
    }

    private JsonObject serviceMethodToJson(SpringBridge.ServiceMethodInfo serviceMethodInfo, boolean availableInTypescript) {
        JsonObject json = Json.createObject();
        json.put("className", JavaReflectionUtil.getClassName(serviceMethodInfo.serviceClass()));
        json.put("filename", this.projectManager.getFileForClass(serviceMethodInfo.serviceClass()).getAbsolutePath());
        json.put("lineNumber", 1.0);
        json.put("methodName", serviceMethodInfo.serviceMethod().getName());
        List<JavaReflectionUtil.ParameterTypeInfo> parameterTypes = JavaReflectionUtil.getParameterTypes(serviceMethodInfo.serviceMethod(), serviceMethodInfo.serviceClass());
        json.put("parameters", (JsonValue)parameterTypes.stream().map(param -> {
            JsonObject paramInfo = Json.createObject();
            paramInfo.put("name", param.parameterName());
            paramInfo.put("type", (JsonValue)this.typeToJson(param.typeInfo()));
            return paramInfo;
        }).collect(JsonUtils.asArray()));
        JavaReflectionUtil.TypeInfo returnTypeInfo = JavaReflectionUtil.getReturnType(serviceMethodInfo.serviceMethod(), serviceMethodInfo.serviceClass());
        json.put("returnType", (JsonValue)this.typeToJson(returnTypeInfo));
        json.put("availableInTypescript", availableInTypescript);
        try {
            AccessRequirement req = AccessRequirementUtil.getAccessRequirement(serviceMethodInfo.serviceMethod(), serviceMethodInfo.serviceClass());
            json.put("accessRequirement", (JsonValue)JsonUtils.beanToJson((Object)req));
        }
        catch (Exception e) {
            UiServiceHandler.getLogger().error("Unable to determine access requirement", (Throwable)e);
        }
        return json;
    }

    private JsonObject typeToJson(JavaReflectionUtil.TypeInfo typeInfo) {
        JsonObject json = Json.createObject();
        json.put("typeName", typeInfo.typeName());
        json.put("typeParameters", (JsonValue)typeInfo.typeParameters().stream().map(this::typeToJson).collect(JsonUtils.asArray()));
        return json;
    }

    public static int sortByClassAndMethodName(SpringBridge.ServiceMethodInfo e1, SpringBridge.ServiceMethodInfo e2) {
        return UiServiceHandler.sortByClassAndMethodName(e1.serviceClass(), e1.serviceMethod(), e2.serviceClass(), e2.serviceMethod());
    }

    private static int sortByClassAndMethodName(Class<?> class1, Method method1, Class<?> class2, Method method2) {
        if (!class1.equals(class2)) {
            return JavaReflectionUtil.getClassName(class1).compareTo(JavaReflectionUtil.getClassName(class2));
        }
        return method1.getName().compareTo(method2.getName());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(UiServiceHandler.class);
    }
}

