package com.vaadin.copilot;

import java.util.Set;

import com.vaadin.base.devserver.DebugWindowConnection;
import com.vaadin.flow.hotswap.VaadinHotswapper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.server.VaadinSession;

import elemental.json.Json;
import elemental.json.JsonObject;

public class HotswapListener implements VaadinHotswapper {

    @Override
    public boolean onClassLoadEvent(VaadinSession vaadinSession, Set<Class<?>> classes, boolean redefined) {
        BrowserLiveReload liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService(vaadinSession.getService())
                .orElse(null);

        if (liveReload != null) {
            JsonObject msg = Json.createObject();
            msg.put("command", Copilot.PREFIX + "java-after-update");
            ((DebugWindowConnection) liveReload).broadcast(msg);
        }

        return false;
    }
}
