/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.docs;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.plugins.docs.DocsDataLoader;
import com.vaadin.copilot.plugins.docs.DocsException;
import com.vaadin.copilot.plugins.docs.DocsRequest;
import com.vaadin.copilot.plugins.docs.DocsResponse;
import elemental.json.Json;
import elemental.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocsHandler
implements CopilotCommand {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final DocsDataLoader docsDataLoader = new DocsDataLoader();

    public DocsHandler() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-docs")) {
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                DocsRequest docsRequest = (DocsRequest)this.objectMapper.readValue(data.toJson(), DocsRequest.class);
                DocsResponse response = this.docsDataLoader.get(docsRequest);
                responseData.put("content", this.objectMapper.writeValueAsString((Object)response));
            }
            catch (DocsException exception) {
                responseData.put("error", (double)exception.getCode());
            }
            catch (Exception ex) {
                responseData.put("error", 500.0);
                this.getLogger().error(ex.getMessage(), (Throwable)ex);
            }
            devToolsInterface.send("copilot-get-docs-response", responseData);
            return true;
        }
        return false;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public boolean canBeParallelCommand(String command) {
        return command.equalsIgnoreCase("get-docs");
    }
}

