/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.info;

import com.vaadin.copilot.CopilotVersion;
import com.vaadin.copilot.plugins.info.JdkInfo;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CopilotInfo
implements Serializable {
    private final List<NameAndVersion> versions = new ArrayList<NameAndVersion>();
    private final JdkInfo jdkInfo;

    public CopilotInfo(ApplicationConfiguration applicationConfiguration) {
        if (EndpointRequestUtil.isHillaAvailable()) {
            this.versions.add(new NameAndVersion("Hilla", CopilotInfo.fetchHillaVersion()));
        }
        this.versions.add(new NameAndVersion("Flow", Version.getFullVersion()));
        if (CopilotInfo.isVaadinAvailable()) {
            this.versions.add(new NameAndVersion("Vaadin", CopilotInfo.fetchVaadinVersion()));
        }
        this.versions.add(new NameAndVersion("Copilot", CopilotVersion.getVersion()));
        String frontendHotswap = applicationConfiguration.getMode() == Mode.DEVELOPMENT_FRONTEND_LIVERELOAD ? "Enabled, using Vite" : "Disabled, using pre-built bundle";
        this.versions.add(new NameAndVersion("Frontend Hotswap", frontendHotswap));
        this.versions.add(new NameAndVersion("OS", CopilotInfo.fetchOperatingSystem()));
        this.versions.add(new NameAndVersion("Java", CopilotInfo.fetchJavaVersion()));
        this.jdkInfo = JdkInfo.get();
    }

    public static String fetchJavaVersion() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        return vendor + " " + version;
    }

    public static String fetchOperatingSystem() {
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        return arch + " " + name + " " + version;
    }

    public static String fetchVaadinVersion() {
        return CopilotInfo.isVaadinAvailable() ? Platform.getVaadinVersion().orElse("?") : "-";
    }

    public static String fetchHillaVersion() {
        return EndpointRequestUtil.isHillaAvailable() ? Platform.getHillaVersion().orElse("?") : "-";
    }

    public List<NameAndVersion> getVersions() {
        return this.versions;
    }

    public JdkInfo getJdkInfo() {
        return this.jdkInfo;
    }

    private static boolean isVaadinAvailable() {
        return Thread.currentThread().getContextClassLoader().getResource("META-INF/maven/com.vaadin/vaadin-core/pom.properties") != null;
    }

    public record NameAndVersion(String name, String version) implements Serializable
    {
    }
}

