/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.i18n;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.ComponentSourceFinder;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.JavaSourcePathDetector;
import com.vaadin.copilot.ProjectFileManager;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.Util;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.JavaBatchRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.exception.ComponentInfoNotFoundException;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nHandler
implements CopilotCommand {
    private static final String[] propertiesToTranslate = new String[]{"label", "placeholder", "title", "text", "helperText"};
    private static final String GET_TRANSLATIONS_COMMAND = "get-translations";
    private static final String WRITE_TRANSLATIONS_COMMAND = "write-translations";
    private static final String SET_TRANSLATABLE_PROPERTIES_COMMAND = "set-translatable-properties";
    private static final String GET_TRANSLATABLE_PROPERTIES_COMMAND = "get-translatable-properties";
    private static final String TRANSLATIONS_COMMAND = "copilot-translations";
    private static final String TRANSLATIONS_FILE_WRITTEN_COMMAND = "copilot-translations-file-written";
    private static final String TRANSLATABLE_PROPERTIES_SET_COMMAND = "copilot-translatable-properties-set";
    private static final String TRANSLATABLE_PROPERTIES_GET_COMMAND = "copilot-translatable-properties-get";
    private static final String TRANSLATIONS_PROPERTY = "translations";
    private static final String CURRENT_VIEW_PROPERTY = "currentView";
    private static final String TRANSLATIONS_FILES_PROPERTY = "translationsFiles";
    private static final String COMPONENTS_PROPERTY = "components";
    private static final String COMPONENT_PROPERTY = "component";
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String KEY_PROPERTY = "key";
    private static final String NAME_PROPERTY = "name";
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_ERROR_CODE = "errorCode";
    public static final int GET_TRANSLATION_ERROR = -1;
    public static final int WRITE_TRANSLATION_ERROR = -2;
    public static final int SET_TRANSLATABLE_PROPERTY_ERROR = -3;
    public static final int GET_TRANSLATABLE_PROPERTY_ERROR = -4;
    private static final String WRITE_UNDO_LABEL = "I18N Properties Write";
    private static final String PROPERTIES_FILE = "translations.properties";
    private final ProjectManager projectManager;
    private final ComponentSourceFinder sourceFinder;

    public I18nHandler(ProjectManager projectManager) {
        this(projectManager, new ComponentSourceFinder(projectManager));
    }

    public I18nHandler(ProjectManager projectManager, ComponentSourceFinder sourceFinder) {
        this.projectManager = projectManager;
        this.sourceFinder = sourceFinder;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals(GET_TRANSLATIONS_COMMAND)) {
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.handleGetTranslations(responseData);
            }
            catch (Exception e) {
                responseData.put(STATUS_ERROR, true);
                responseData.put(STATUS_ERROR_CODE, -1.0);
                this.getLogger().debug("Unable to get project translations", (Throwable)e);
            }
            devToolsInterface.send(TRANSLATIONS_COMMAND, responseData);
            return true;
        }
        if (command.equals(WRITE_TRANSLATIONS_COMMAND)) {
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.handleWriteTranslationsFile(data.getObject(TRANSLATIONS_PROPERTY), data.getObject(CURRENT_VIEW_PROPERTY));
            }
            catch (Exception e) {
                responseData.put(STATUS_ERROR, true);
                responseData.put(STATUS_ERROR_CODE, -2.0);
                this.getLogger().error("Unable to write project translations", (Throwable)e);
            }
            devToolsInterface.send(TRANSLATIONS_FILE_WRITTEN_COMMAND, responseData);
            return true;
        }
        if (command.equals(SET_TRANSLATABLE_PROPERTIES_COMMAND)) {
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.handleSetComponentProperties(data.getArray(COMPONENTS_PROPERTY));
                this.handleWriteTranslationsFile(data.getObject(TRANSLATIONS_PROPERTY), data.getObject(CURRENT_VIEW_PROPERTY));
            }
            catch (Exception e) {
                responseData.put(STATUS_ERROR, true);
                responseData.put(STATUS_ERROR_CODE, -3.0);
                this.getLogger().error("Failed to set translatable properties", (Throwable)e);
            }
            devToolsInterface.send(TRANSLATABLE_PROPERTIES_SET_COMMAND, responseData);
            return true;
        }
        if (command.equals(GET_TRANSLATABLE_PROPERTIES_COMMAND)) {
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.handleGetTranslatableProperties(data, responseData);
            }
            catch (Exception e) {
                responseData.put(STATUS_ERROR, true);
                responseData.put(STATUS_ERROR_CODE, -4.0);
                this.getLogger().debug("Failed to get translatable properties", (Throwable)e);
            }
            devToolsInterface.send(TRANSLATABLE_PROPERTIES_GET_COMMAND, responseData);
            return true;
        }
        return false;
    }

    private void handleGetTranslations(JsonObject responseData) throws IOException {
        Optional<Path> translationsFilePath;
        JsonObject translations = Json.createObject();
        responseData.put(TRANSLATIONS_PROPERTY, (JsonValue)translations);
        JsonObject translationsFiles = Json.createObject();
        responseData.put(TRANSLATIONS_FILES_PROPERTY, (JsonValue)translationsFiles);
        Path translationsDirectory = this.getTranslationsDirectory(null).orElse(null);
        if (translationsDirectory != null && Files.exists(translationsDirectory, new LinkOption[0])) {
            try (Stream<Path> paths = Files.list(translationsDirectory);){
                String[] translationsFilesList;
                for (String translationsFile : translationsFilesList = (String[])paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".properties") && path.getFileName().toString().startsWith(TRANSLATIONS_PROPERTY)).map(Path::getFileName).map(Path::toString).sorted().toArray(String[]::new)) {
                    Path translationsFilePath2 = translationsDirectory.resolve(translationsFile);
                    String translationsFileContent = this.projectManager.readFile(translationsFilePath2);
                    translationsFiles.put(translationsFile, translationsFileContent);
                }
            }
        }
        if ((translationsFilePath = this.getDefaultTranslationsFile()).isPresent()) {
            ResourceBundle resourceBundle = this.getBundle(Locale.ROOT);
            resourceBundle.keySet().forEach(key -> translations.put(key, resourceBundle.getString((String)key)));
        }
    }

    private void handleWriteTranslationsFile(JsonObject translations, JsonObject currentView) throws IOException, ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        PropertiesConfigurationLayout layout = new PropertiesConfigurationLayout();
        layout.setGlobalSeparator("=");
        this.loadConfig(layout, config);
        for (String key : translations.keys()) {
            config.setProperty(key, (Object)translations.getString(key));
            layout.getComment(key);
        }
        Optional<File> referenceFile = Util.findCurrentViewFile(this.projectManager, currentView);
        this.writeConfig(layout, config, referenceFile.orElse(null));
    }

    private void handleSetComponentProperties(JsonArray components) {
        HashMap<ComponentTypeAndSourceLocation, JsonArray> componentProperties = new HashMap<ComponentTypeAndSourceLocation, JsonArray>();
        for (int i = 0; i < components.length(); ++i) {
            JsonObject componentObject = components.getObject(i);
            JsonObject component2 = componentObject.getObject(COMPONENT_PROPERTY);
            ComponentTypeAndSourceLocation componentInfo = this.sourceFinder.findTypeAndSourceLocation(component2);
            JsonArray properties = componentObject.getArray(PROPERTIES_PROPERTY);
            componentProperties.put(componentInfo, properties);
        }
        JavaBatchRewriter batchRewriter = new JavaBatchRewriter(this.projectManager, new ArrayList<ComponentTypeAndSourceLocation>(componentProperties.keySet()));
        batchRewriter.forEachComponent((source, component, rewriter) -> {
            component.rewriter().addImport("com.vaadin.flow.i18n.I18NProvider.translate", true, false);
            JsonArray properties = (JsonArray)componentProperties.get(source);
            for (int p = 0; p < properties.length(); ++p) {
                JsonObject propertyInfo = properties.getObject(p);
                String property = propertyInfo.getString(NAME_PROPERTY);
                String key = propertyInfo.getString(KEY_PROPERTY);
                JavaRewriter.Code code = new JavaRewriter.Code(String.format("translate(\"%s\")", key));
                String setter = this.getSetterName(property);
                component.rewriter().replaceFunctionCall(component, setter, code);
            }
        });
        batchRewriter.writeResult();
    }

    private void handleGetTranslatableProperties(JsonObject data, JsonObject responseData) throws IOException, IllegalArgumentException, ComponentInfoNotFoundException {
        JsonObject component = data.getObject(COMPONENT_PROPERTY);
        ComponentTypeAndSourceLocation typeAndSourceLocation = this.sourceFinder.findTypeAndSourceLocation(component);
        JavaRewriter rewriter = new JavaRewriter(this.projectManager.readFile(typeAndSourceLocation.javaFile()));
        ComponentInfo info = rewriter.findComponentInfo(typeAndSourceLocation);
        responseData.put(COMPONENT_PROPERTY, (JsonValue)component);
        JsonArray listOfProps = Json.createArray();
        for (String property : propertiesToTranslate) {
            try {
                MethodCallExpr methodCall;
                Object result = rewriter.getPropertyValue(info, property);
                if (result == null) continue;
                JsonObject propertyObj = Json.createObject();
                propertyObj.put(NAME_PROPERTY, property);
                if (result instanceof String) {
                    String value = (String)result;
                    propertyObj.put("value", value);
                } else if (result instanceof MethodCallExpr && (methodCall = (MethodCallExpr)result).getNameAsString().equals("translate")) {
                    Optional<String> keyValue = this.getStringArgument(methodCall.getArgument(0));
                    if (keyValue.isPresent()) {
                        propertyObj.put(KEY_PROPERTY, keyValue.get());
                    } else if (methodCall.getArguments().size() > 1) {
                        keyValue = this.getStringArgument(methodCall.getArgument(1));
                        keyValue.ifPresent(s -> propertyObj.put(KEY_PROPERTY, s));
                    }
                }
                if (propertyObj.keys().length != 2) continue;
                listOfProps.set(listOfProps.length(), (JsonValue)propertyObj);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        responseData.put(PROPERTIES_PROPERTY, (JsonValue)listOfProps);
    }

    private Optional<String> getStringArgument(Expression argument) {
        if (argument.isStringLiteralExpr()) {
            return Optional.of(argument.asStringLiteralExpr().getValue());
        }
        return Optional.empty();
    }

    private String getSetterName(String property) {
        return "set" + SharedUtil.capitalize((String)property);
    }

    private void loadConfig(PropertiesConfigurationLayout layout, PropertiesConfiguration config) throws IOException, ConfigurationException {
        Optional<Path> defaultTranslationsFile = this.getDefaultTranslationsFile();
        if (defaultTranslationsFile.isEmpty()) {
            return;
        }
        String content = this.projectManager.readFile(defaultTranslationsFile.get());
        layout.load(config, (Reader)new StringReader(content));
    }

    private void writeConfig(PropertiesConfigurationLayout layout, PropertiesConfiguration config, File referenceFile) throws IOException, ConfigurationException {
        StringWriter writer = new StringWriter();
        layout.save(config, (Writer)writer);
        Path defaultTranslationsFile = this.getDefaultTranslationsFile().orElse(null);
        if (defaultTranslationsFile == null) {
            Optional<Path> translationsDirectory = this.getTranslationsDirectory(referenceFile);
            if (translationsDirectory.isEmpty()) {
                String module = Optional.ofNullable(referenceFile).map(ProjectFileManager.getInstance()::findModule).map(Object::toString).orElse("?");
                throw new IllegalArgumentException("The translation file cannot be created for the module/project in " + module + " as no resource folder is found");
            }
            defaultTranslationsFile = translationsDirectory.get().resolve(PROPERTIES_FILE);
        }
        this.projectManager.writeFile(defaultTranslationsFile, WRITE_UNDO_LABEL, writer.toString());
    }

    private Optional<Path> getDefaultTranslationsFile() throws IOException {
        String defaultTranslationFilename = Path.of("vaadin-i18n", PROPERTIES_FILE).toString();
        return this.projectManager.findResource(defaultTranslationFilename);
    }

    private Optional<Path> getTranslationsDirectory(File referenceFile) throws IOException {
        JavaSourcePathDetector.ModuleInfo module;
        Optional<Path> existingDirectory = this.projectManager.findResource("vaadin-i18n");
        if (existingDirectory.isPresent()) {
            return existingDirectory;
        }
        List<JavaSourcePathDetector.ModuleInfo> modules = ProjectFileManager.getInstance().getModules();
        if (modules.size() == 1) {
            module = modules.get(0);
        } else if (referenceFile != null) {
            module = ProjectFileManager.getInstance().findModule(referenceFile).orElseThrow(() -> new IllegalArgumentException("The module for the file " + String.valueOf(referenceFile) + " could not be found"));
        } else {
            throw new IllegalArgumentException("Unable to determine the property translations directory. The project has multiple modules but no reference file was given");
        }
        return module.getOrGuessResourceFolder().map(path -> path.resolve("vaadin-i18n"));
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("vaadin-i18n.translations", locale);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

