/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.devsetup;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.plugins.devsetup.DevSetupInfo;
import com.vaadin.copilot.plugins.info.JdkInfo;
import elemental.json.Json;
import elemental.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevSetupHandler
implements CopilotCommand {
    private final CopilotIDEPlugin idePlugin;
    private final ObjectMapper objectMapper;

    public DevSetupHandler(CopilotIDEPlugin idePlugin) {
        this.idePlugin = idePlugin;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if ("get-dev-setup-info".equals(command)) {
            JsonObject responseData = Json.createObject();
            JdkInfo jdkInfo = JdkInfo.get();
            try {
                DevSetupInfo devSetupInfo = new DevSetupInfo(jdkInfo, this.idePlugin.getPluginInfo());
                responseData.put("content", this.objectMapper.writeValueAsString((Object)devSetupInfo));
                devToolsInterface.send("copilot-get-dev-setup-info-response", responseData);
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

