/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor;

import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriteable;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSSelectorSimpleMember;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSSelectorMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriter;
import com.vaadin.copilot.CopilotException;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.plugins.themeeditor.utils.CssRule;
import com.vaadin.copilot.plugins.themeeditor.utils.ThemeEditorException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class ThemeModifier {
    private static final String COPILOT_THEME_MODIFY_UNDO_LABEL = CopilotIDEPlugin.undoLabel("Theme Modify");
    private static final String COPILOT_STYLES_MODIFY_UNDO_LABEL = CopilotIDEPlugin.undoLabel("Styles Modify");
    public static final String THEME_EDITOR_CSS = "theme-editor.css";
    private static final String HEADER_TEXT = "This file has been created by the Vaadin Theme Editor. Please note that\nmanual changes to individual CSS properties may be overwritten by the theme editor.";
    private static final String DEFAULT_FONT_NAME = "Default";
    private static final String FONT_CDN_URL = "https://cdn.jsdelivr.net/fontsource/css/%s@latest/index.css";
    private final ProjectManager projectManager;
    private final File themeFolder;
    private final File themeEditorStyles;
    private boolean importPresent;

    public ThemeModifier(ProjectManager projectManager) throws ThemeEditorException {
        this.projectManager = projectManager;
        this.themeFolder = this.getThemeFolder();
        this.themeEditorStyles = new File(this.themeFolder, this.getCssFileName());
    }

    public void setThemeProperties(List<CssRule> rules) {
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        for (CssRule rule : rules) {
            for (Map.Entry<String, String> property : rule.getProperties().entrySet()) {
                if (property.getValue() != null && !property.getValue().isBlank()) {
                    this.setCssProperty(styleSheet, rule.getSelector(), property.getKey(), property.getValue());
                    continue;
                }
                this.removeCssProperty(styleSheet, rule.getSelector(), property.getKey());
            }
        }
        this.sortStyleSheet(styleSheet);
        this.writeStyleSheet(styleSheet);
        this.insertImportIfNotExists();
    }

    public void setFont(String fontName) {
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        styleSheet.removeAllImportRules();
        if (DEFAULT_FONT_NAME.equals(fontName)) {
            this.removeCssProperty(styleSheet, "html", "--lumo-font-family");
        } else {
            String fontPackageName = this.getFontPackageName(fontName);
            String fontCdnUrl = String.format(FONT_CDN_URL, fontPackageName);
            CSSImportRule importRule = new CSSImportRule(fontCdnUrl);
            styleSheet.addImportRule(importRule);
            this.setCssProperty(styleSheet, "html", "--lumo-font-family", fontName);
        }
        this.sortStyleSheet(styleSheet);
        this.writeStyleSheet(styleSheet);
    }

    private String getFontPackageName(String fontName) {
        if (fontName == null) {
            return null;
        }
        return fontName.replace(" ", "-").toLowerCase(Locale.ENGLISH);
    }

    public String getCss() {
        if (this.noStyleSheet()) {
            return "";
        }
        try {
            StringWriter stringWriter = new StringWriter();
            CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
            CSSWriter cssWriter = new CSSWriter().setWriteHeaderText(false);
            cssWriter.getSettings().setOptimizedOutput(true).setRemoveUnnecessaryCode(true);
            cssWriter.writeCSS(styleSheet, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new ThemeEditorException("Cannot read stylesheet file.");
        }
    }

    public List<CssRule> getCssRules(List<String> selectors) {
        if (this.noStyleSheet()) {
            return Collections.emptyList();
        }
        List<CSSSelector> cssSelectors = selectors.stream().map(this::parseSelector).toList();
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        return styleSheet.getAllStyleRules().stream().filter(rule -> rule.getSelectorCount() > 0).filter(rule -> cssSelectors.contains(rule.getSelectorAtIndex(0))).map(this::toCssRule).toList();
    }

    public void replaceClassName(String tagName, String oldClassName, String newClassName) {
        if (this.noStyleSheet()) {
            return;
        }
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        this.replaceClassName(styleSheet, tagName, oldClassName, newClassName);
        this.writeStyleSheet(styleSheet);
    }

    public int getRuleLocationLine(String selectorString) {
        CSSSelector selector;
        if (this.noStyleSheet()) {
            return -1;
        }
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        CSSStyleRule rule = this.findRuleBySelector(styleSheet, selector = this.parseSelector(selectorString));
        if (rule == null) {
            return -1;
        }
        return rule.getSourceLocation().getFirstTokenBeginLineNumber();
    }

    public void createEmptyStyleRule(String selector) {
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        if (selector != null) {
            CSSSelector cssSelector = new CSSSelector().addMember((ICSSSelectorMember)new CSSSelectorSimpleMember(selector));
            CSSStyleRule cssStyleRule = new CSSStyleRule().addSelector(cssSelector);
            styleSheet.addRule((ICSSTopLevelRule)cssStyleRule);
            this.sortStyleSheet(styleSheet);
        }
        this.writeStyleSheet(styleSheet);
        this.insertImportIfNotExists();
    }

    public List<String> getExistingClassNames() {
        if (this.noStyleSheet()) {
            return Collections.emptyList();
        }
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        return styleSheet.getAllStyleRules().stream().map(this::toCssRule).map(CssRule::getSelector).map(k -> k.split("::")[0]).toList();
    }

    protected boolean noStyleSheet() {
        return !this.themeEditorStyles.exists();
    }

    protected String getCssFileName() {
        return THEME_EDITOR_CSS;
    }

    protected String getHeaderText() {
        return HEADER_TEXT;
    }

    protected File getThemeFolder() {
        return this.projectManager.getThemeFolder().orElse(null);
    }

    public File getStyleSheetFile() {
        return this.themeEditorStyles;
    }

    protected CascadingStyleSheet getCascadingStyleSheet() {
        if (this.noStyleSheet()) {
            return new CascadingStyleSheet();
        }
        try {
            String content = this.projectManager.readFile(this.themeEditorStyles);
            CascadingStyleSheet styleSheet = CSSReader.readFromString((String)content, (Charset)StandardCharsets.UTF_8, (ECSSVersion)ECSSVersion.LATEST);
            if (!this.importPresent) {
                this.insertImportIfNotExists();
                this.importPresent = true;
            }
            return styleSheet;
        }
        catch (IOException ex) {
            throw new CopilotException("Cannot read file " + this.themeEditorStyles.getPath());
        }
    }

    protected void setCssProperty(CascadingStyleSheet styleSheet, String selector, String property, String value) {
        CSSStyleRule newRule = this.createStyleRule(selector, property, value);
        CSSStyleRule existingRule = this.findRuleBySelector(styleSheet, newRule);
        if (existingRule == null) {
            styleSheet.addRule((ICSSTopLevelRule)newRule);
        } else {
            CSSDeclaration newDeclaration = newRule.getDeclarationAtIndex(0);
            CSSDeclaration existingDeclaration = existingRule.getDeclarationOfPropertyName(property);
            if (existingDeclaration == null) {
                existingRule.addDeclaration(newDeclaration);
            } else {
                existingDeclaration.setExpression(newDeclaration.getExpression());
            }
        }
    }

    protected void removeCssProperty(CascadingStyleSheet styleSheet, String selector, String property) {
        CSSStyleRule newRule = this.createStyleRule(selector, property, "none");
        CSSStyleRule existingRule = this.findRuleBySelector(styleSheet, newRule);
        if (existingRule != null) {
            this.removeProperty(existingRule, newRule);
            if (existingRule.getDeclarationCount() == 0) {
                styleSheet.removeRule((ICSSTopLevelRule)existingRule);
            }
        }
    }

    protected void writeStyleSheet(CascadingStyleSheet styleSheet) {
        try {
            CSSWriter writer = new CSSWriter().setWriteHeaderText(true).setHeaderText(this.getHeaderText());
            writer.getSettings().setOptimizedOutput(false);
            StringWriter stringWriter = new StringWriter();
            writer.writeCSS(styleSheet, (Writer)stringWriter);
            this.projectManager.writeFile(this.themeEditorStyles, COPILOT_THEME_MODIFY_UNDO_LABEL, stringWriter.toString());
        }
        catch (IOException e) {
            throw new ThemeEditorException("Cannot write " + this.themeEditorStyles.getPath(), e);
        }
    }

    protected void sortStyleSheet(CascadingStyleSheet styleSheet) {
        List<CSSStyleRule> sortedRules = styleSheet.getAllStyleRules().stream().sorted(Comparator.comparing(r -> r.getSelectorAtIndex(0).getAsCSSString())).collect(Collectors.toList());
        for (CSSStyleRule rule : sortedRules) {
            List<CSSDeclaration> sortedDeclarations = rule.getAllDeclarations().stream().sorted(Comparator.comparing(ICSSWriteable::getAsCSSString)).collect(Collectors.toList());
            rule.removeAllDeclarations();
            sortedDeclarations.forEach(arg_0 -> ((CSSStyleRule)rule).addDeclaration(arg_0));
        }
        sortedRules.forEach(arg_0 -> ((CascadingStyleSheet)styleSheet).removeRule(arg_0));
        sortedRules.forEach(arg_0 -> ((CascadingStyleSheet)styleSheet).addRule(arg_0));
    }

    protected CSSStyleRule createStyleRule(String selector, String property, String value) {
        return CSSReader.readFromString((String)(selector + "{" + property + ": " + value + "}"), (Charset)StandardCharsets.UTF_8, (ECSSVersion)ECSSVersion.LATEST).getStyleRuleAtIndex(0);
    }

    protected void removeProperty(CSSStyleRule existingRule, CSSStyleRule newRule) {
        CSSDeclaration newDeclaration = newRule.getDeclarationAtIndex(0);
        String property = newDeclaration.getProperty();
        CSSDeclaration declaration = existingRule.getDeclarationOfPropertyName(property);
        if (declaration != null) {
            existingRule.removeDeclaration(declaration);
        }
    }

    protected CSSStyleRule findRuleBySelector(CascadingStyleSheet styleSheet, CSSStyleRule rule) {
        return styleSheet.getAllStyleRules().stream().filter(r -> r.getAllSelectors().containsAll((Collection)rule.getAllSelectors())).findFirst().orElse(null);
    }

    protected CSSStyleRule findRuleBySelector(CascadingStyleSheet styleSheet, CSSSelector selector) {
        return styleSheet.getAllStyleRules().stream().filter(r -> r.getAllSelectors().contains((Object)selector)).findFirst().orElse(null);
    }

    protected void replaceClassName(CascadingStyleSheet styleSheet, String tagName, String oldClassName, String newClassName) {
        String dotOldClassName = "." + oldClassName;
        String dotNewClassName = "." + newClassName;
        for (CSSStyleRule rule : styleSheet.getAllStyleRules()) {
            for (CSSSelector selector : rule.getAllSelectors()) {
                if (selector.getAllMembers().containsNone(m -> tagName.equals(m.getAsCSSString()))) continue;
                ArrayList members = new ArrayList();
                selector.getAllMembers().findAll(m -> dotOldClassName.equals(m.getAsCSSString()), members::add);
                members.forEach(m -> {
                    int index = selector.getAllMembers().indexOf(m);
                    selector.removeMember(m);
                    selector.addMember(index, (ICSSSelectorMember)new CSSSelectorSimpleMember(dotNewClassName));
                });
            }
        }
    }

    protected void insertImportIfNotExists() {
        File themeStyles = new File(this.themeFolder, "styles.css");
        CascadingStyleSheet styleSheet = CSSReader.readFromFile((File)themeStyles, (Charset)StandardCharsets.UTF_8, (ECSSVersion)ECSSVersion.LATEST);
        CSSImportRule expectedRule = new CSSImportRule(this.getCssFileName());
        if (!styleSheet.getAllImportRules().contains((Object)expectedRule)) {
            try {
                List<String> lines = this.projectManager.readLines(themeStyles);
                lines.add(0, "@import \"" + this.getCssFileName() + "\";");
                String content = lines.stream().collect(Collectors.joining(System.lineSeparator()));
                this.projectManager.writeFile(themeStyles, COPILOT_STYLES_MODIFY_UNDO_LABEL, content);
            }
            catch (IOException e) {
                throw new ThemeEditorException("Cannot insert theme-editor.css @import", e);
            }
        }
    }

    protected CssRule toCssRule(CSSStyleRule rule) {
        CSSSelector selector = rule.getSelectorAtIndex(0);
        HashMap<String, String> properties = new HashMap<String, String>();
        rule.getAllDeclarations().forEach(cssDeclaration -> properties.put(cssDeclaration.getProperty(), cssDeclaration.getExpressionAsCSSString()));
        return new CssRule(selector.getAsCSSString(), properties);
    }

    protected CSSSelector parseSelector(String selector) {
        CascadingStyleSheet css = CSSReader.readFromString((String)(selector + "{}"), (ECSSVersion)ECSSVersion.LATEST);
        return ((CSSStyleRule)css.getAllStyleRules().getFirst()).getSelectorAtIndex(0);
    }
}

