/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.ProjectFileManager;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class ComponentSourceFinder {
    private static String[] prefixesToSkip = new String[]{"com.vaadin.flow.component.", "com.vaadin.flow.di.", "com.vaadin.flow.dom.", "com.vaadin.flow.internal.", "com.vaadin.flow.spring.", "com.vaadin.cdi.", "java.", "jdk.", "org.springframework.beans.", "org.jboss.weld."};
    private final ProjectManager projectManager;

    public ComponentSourceFinder(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(JsonObject component) {
        return this.findTypeAndSourceLocation(component, false);
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(JsonObject component, boolean includeChildren) {
        return this.findTypeAndSourceLocation((int)component.getNumber("uiId"), (int)component.getNumber("nodeId"), includeChildren);
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(int uiId, int nodeId) {
        return this.findTypeAndSourceLocation(uiId, nodeId, false);
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(int uiId, int nodeId, boolean includeChildren) {
        AtomicReference<Object> info = new AtomicReference<Object>(null);
        VaadinSession vaadinSession = this.projectManager.getVaadinSession();
        vaadinSession.accessSynchronously((Command & Serializable)() -> {
            Element element = vaadinSession.findElement(uiId, nodeId);
            Optional c = element.getComponent();
            if (c.isPresent()) {
                ComponentTypeAndSourceLocation componentInfo = this.findTypeAndSourceLocation((Component)c.get(), includeChildren);
                info.set(componentInfo);
            }
        });
        ComponentTypeAndSourceLocation res = info.get();
        if (res == null) {
            throw new IllegalArgumentException("Unable to find component in source");
        }
        return res;
    }

    public ComponentTypeAndSourceLocation findTypeAndSourceLocation(Component component, boolean includeChildren) {
        Optional parent = component.getParent();
        ComponentTypeAndSourceLocation parentInfo = parent.map(this::_getSourceLocation).orElse(null);
        ArrayList<ComponentTypeAndSourceLocation> children = new ArrayList<ComponentTypeAndSourceLocation>();
        if (includeChildren) {
            component.getChildren().forEach(child -> {
                ComponentTypeAndSourceLocation childInfo = this.findTypeAndSourceLocation((Component)child, true);
                children.add(childInfo);
            });
        }
        return this.getSourceLocation(component, parentInfo, children);
    }

    public ComponentTypeAndSourceLocation _getSourceLocation(Component component) {
        return this.getSourceLocation(component, null, null);
    }

    private ComponentTypeAndSourceLocation getSourceLocation(Component component, ComponentTypeAndSourceLocation parentInfo, List<ComponentTypeAndSourceLocation> children) {
        ComponentTracker.Location[] createLocations = ComponentTracker.findCreateLocations((Component)component);
        ComponentTracker.Location[] attachLocations = ComponentTracker.findAttachLocations((Component)component);
        Optional<LocationAndFile> create = this.findProjectLocation(createLocations);
        Optional<LocationAndFile> attach = this.findProjectLocation(attachLocations);
        Optional<ComponentTracker.Location> createLocation = create.map(LocationAndFile::location);
        Optional<ComponentTracker.Location> attachLocation = attach.map(LocationAndFile::location);
        Optional<File> javaFile = createLocation.map(this.projectManager::getSourceFile);
        return new ComponentTypeAndSourceLocation(component.getClass(), ComponentSourceFinder.findInheritanceChain(component), component, javaFile, createLocation, attachLocation, parentInfo, children);
    }

    public static List<Class<?>> findInheritanceChain(Component component) {
        ArrayList inheritanceChain = new ArrayList();
        inheritanceChain.add(component.getClass());
        for (Class<?> superClass = component.getClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            inheritanceChain.add(superClass);
        }
        return inheritanceChain;
    }

    private Optional<LocationAndFile> findProjectLocation(ComponentTracker.Location[] allLocations) {
        if (allLocations == null) {
            return Optional.empty();
        }
        List<ComponentTracker.Location> locations = Stream.of(allLocations).filter(location -> {
            for (String prefixToSkip : prefixesToSkip) {
                if (!location.className().startsWith(prefixToSkip)) continue;
                return false;
            }
            return true;
        }).toList();
        for (ComponentTracker.Location location2 : locations) {
            File file = ProjectFileManager.getInstance().getSourceFile(location2);
            if (!file.exists()) continue;
            return Optional.of(new LocationAndFile(location2, file));
        }
        return Optional.empty();
    }

    private record LocationAndFile(ComponentTracker.Location location, File file) {
    }
}

