/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import com.vaadin.copilot.CopilotException;
import com.vaadin.copilot.CopilotSession;
import com.vaadin.copilot.CopilotStatus;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonObject;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public class Copilot
implements DevToolsMessageHandler {
    public static final String PREFIX = "copilot-";
    public static final String ISSUE_TRACKER = "https://github.com/vaadin/copilot/issues";
    public static final Supplier<IllegalStateException> sourceNotFound = () -> new IllegalStateException("The component instance is not created in the project sources");
    private static Boolean enable = null;
    private final Map<VaadinSession, CopilotSession> copilotSessions = Collections.synchronizedMap(new WeakHashMap());

    public void handleConnect(DevToolsInterface devToolsInterface) {
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession == null || !Copilot.isEnabled(vaadinSession)) {
            return;
        }
        this.copilotSessions.computeIfAbsent(vaadinSession, newSession -> {
            try {
                return new CopilotSession((VaadinSession)newSession, devToolsInterface);
            }
            catch (IOException e) {
                throw new CopilotException(e);
            }
        }).handleConnect(devToolsInterface);
    }

    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession == null || !Copilot.isEnabled(vaadinSession)) {
            return false;
        }
        if (!command.startsWith(PREFIX)) {
            return false;
        }
        command = command.substring(PREFIX.length());
        this.copilotSessions.get(vaadinSession).handleMessage(command, data, devToolsInterface);
        return true;
    }

    private static boolean isEnabled(VaadinSession vaadinSession) {
        if (enable == null) {
            enable = CopilotStatus.isEnabled(Copilot.getContext(vaadinSession));
        }
        return enable;
    }

    static VaadinServletContext getContext(VaadinSession vaadinSession) {
        return (VaadinServletContext)vaadinSession.getService().getContext();
    }

    public static boolean isDevelopmentMode() {
        return Boolean.getBoolean("copilot.development");
    }
}

