/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JavaReflectionUtil {
    public static List<ParameterTypeInfo> getParameterTypes(Method method, Class<?> cls) {
        Type[] parameterTypes = GenericTypeReflector.getExactParameterTypes((Method)method, cls);
        ArrayList<ParameterTypeInfo> parameterTypeInfo = new ArrayList<ParameterTypeInfo>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            String name = method.getParameters()[i].getName();
            TypeInfo typeInfo = JavaReflectionUtil.getTypeInfo(parameterTypes[i]);
            parameterTypeInfo.add(new ParameterTypeInfo(name, typeInfo));
        }
        return parameterTypeInfo;
    }

    private static TypeInfo getTypeInfo(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedReturnType = (ParameterizedType)type;
            String typeName = parameterizedReturnType.getRawType().getTypeName();
            List<TypeInfo> typeParameters = Arrays.stream(parameterizedReturnType.getActualTypeArguments()).map(JavaReflectionUtil::getTypeInfo).toList();
            return new TypeInfo(typeName, typeParameters);
        }
        if (type instanceof Class) {
            Class classType = (Class)type;
            return new TypeInfo(classType.getName(), new ArrayList<TypeInfo>());
        }
        return new TypeInfo("???", new ArrayList<TypeInfo>());
    }

    public static TypeInfo getReturnType(Method method, Class<?> cls) {
        Type returnType = GenericTypeReflector.getExactReturnType((Method)method, cls);
        return JavaReflectionUtil.getTypeInfo(returnType);
    }

    public record TypeInfo(String typeName, List<TypeInfo> typeParameters) {
    }

    public record ParameterTypeInfo(String parameterName, TypeInfo typeInfo) {
    }
}

