package com.vaadin.copilot;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.googlecode.gentyref.GenericTypeReflector;

public class JavaReflectionUtil {

    public record TypeInfo(String typeName, List<TypeInfo> typeParameters) {
    }

    public record ParameterTypeInfo(String parameterName, TypeInfo typeInfo) {
    }

    public static List<ParameterTypeInfo> getParameterTypes(Method method, Class<?> cls) {
        Type[] parameterTypes = GenericTypeReflector.getExactParameterTypes(method, cls);
        List<ParameterTypeInfo> parameterTypeInfo = new ArrayList<>();
        for (int i = 0; i < parameterTypes.length; i++) {
            String name = method.getParameters()[i].getName();
            TypeInfo typeInfo = getTypeInfo(parameterTypes[i]);
            parameterTypeInfo.add(new ParameterTypeInfo(name, typeInfo));
        }
        return parameterTypeInfo;
    }

    private static TypeInfo getTypeInfo(Type type) {
        if (type instanceof ParameterizedType parameterizedReturnType) {
            String typeName = parameterizedReturnType.getRawType().getTypeName();
            List<TypeInfo> typeParameters = Arrays.stream(parameterizedReturnType.getActualTypeArguments())
                    .map(JavaReflectionUtil::getTypeInfo).toList();
            return new TypeInfo(typeName, typeParameters);
        } else if (type instanceof Class<?> classType) {
            return new TypeInfo(classType.getName(), new ArrayList<>());
        }
        return new TypeInfo("???", new ArrayList<>());
    }

    public static TypeInfo getReturnType(Method method, Class<?> cls) {
        Type returnType = GenericTypeReflector.getExactReturnType(method, cls);
        return getTypeInfo(returnType);
    }

}
